/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.annotations.Nullable;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.MissingObjectException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.AbbreviatedObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.AnyObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.AsyncObjectLoaderQueue;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.BitmapIndex;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectInserter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectLoader;

public abstract class ObjectReader
implements AutoCloseable {
    public static final int OBJ_ANY = -1;
    protected int streamFileThreshold;

    public abstract ObjectReader newReader();

    public AbbreviatedObjectId abbreviate(AnyObjectId objectId) throws IOException {
        return this.abbreviate(objectId, 7);
    }

    public AbbreviatedObjectId abbreviate(AnyObjectId objectId, int len) throws IOException {
        if (len == 40) {
            return AbbreviatedObjectId.fromObjectId(objectId);
        }
        AbbreviatedObjectId abbrev = objectId.abbreviate(len);
        Collection<ObjectId> matches = this.resolve(abbrev);
        while (1 < matches.size() && len < 40) {
            abbrev = objectId.abbreviate(++len);
            ArrayList<ObjectId> n = new ArrayList<ObjectId>(8);
            for (ObjectId candidate : matches) {
                if (abbrev.prefixCompare(candidate) != 0) continue;
                n.add(candidate);
            }
            if (1 < n.size()) {
                matches = n;
                continue;
            }
            matches = this.resolve(abbrev);
        }
        return abbrev;
    }

    public abstract Collection<ObjectId> resolve(AbbreviatedObjectId var1) throws IOException;

    public boolean has(AnyObjectId objectId) throws IOException {
        return this.has(objectId, -1);
    }

    public boolean has(AnyObjectId objectId, int typeHint) throws IOException {
        try {
            this.open(objectId, typeHint);
            return true;
        }
        catch (MissingObjectException notFound) {
            return false;
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws MissingObjectException, IOException {
        return this.open(objectId, -1);
    }

    public abstract ObjectLoader open(AnyObjectId var1, int var2) throws MissingObjectException, IncorrectObjectTypeException, IOException;

    public abstract Set<ObjectId> getShallowCommits() throws IOException;

    public <T extends ObjectId> AsyncObjectLoaderQueue<T> open(Iterable<T> objectIds, boolean reportMissing) {
        final Iterator<T> idItr = objectIds.iterator();
        return new AsyncObjectLoaderQueue<T>(){
            private T cur;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (ObjectId)idItr.next();
                    return true;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur;
            }

            @Override
            public ObjectLoader open() throws IOException {
                return ObjectReader.this.open((AnyObjectId)this.cur, -1);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.open(objectId, typeHint).getSize();
    }

    public <T extends ObjectId> AsyncObjectSizeQueue<T> getObjectSize(Iterable<T> objectIds, boolean reportMissing) {
        final Iterator<T> idItr = objectIds.iterator();
        return new AsyncObjectSizeQueue<T>(){
            private T cur;
            private long sz;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (ObjectId)idItr.next();
                    this.sz = ObjectReader.this.getObjectSize((AnyObjectId)this.cur, -1);
                    return true;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur;
            }

            @Override
            public long getSize() {
                return this.sz;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    public void setAvoidUnreachableObjects(boolean avoid) {
    }

    public BitmapIndex getBitmapIndex() throws IOException {
        return null;
    }

    @Nullable
    public ObjectInserter getCreatedFromInserter() {
        return null;
    }

    @Override
    public abstract void close();

    public void setStreamFileThreshold(int threshold) {
        this.streamFileThreshold = threshold;
    }

    public int getStreamFileThreshold() {
        return this.streamFileThreshold;
    }

    public static abstract class Filter
    extends ObjectReader {
        protected abstract ObjectReader delegate();

        @Override
        public ObjectReader newReader() {
            return this.delegate().newReader();
        }

        @Override
        public AbbreviatedObjectId abbreviate(AnyObjectId objectId) throws IOException {
            return this.delegate().abbreviate(objectId);
        }

        @Override
        public AbbreviatedObjectId abbreviate(AnyObjectId objectId, int len) throws IOException {
            return this.delegate().abbreviate(objectId, len);
        }

        @Override
        public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
            return this.delegate().resolve(id);
        }

        @Override
        public boolean has(AnyObjectId objectId) throws IOException {
            return this.delegate().has(objectId);
        }

        @Override
        public boolean has(AnyObjectId objectId, int typeHint) throws IOException {
            return this.delegate().has(objectId, typeHint);
        }

        @Override
        public ObjectLoader open(AnyObjectId objectId) throws MissingObjectException, IOException {
            return this.delegate().open(objectId);
        }

        @Override
        public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.delegate().open(objectId, typeHint);
        }

        @Override
        public Set<ObjectId> getShallowCommits() throws IOException {
            return this.delegate().getShallowCommits();
        }

        @Override
        public <T extends ObjectId> AsyncObjectLoaderQueue<T> open(Iterable<T> objectIds, boolean reportMissing) {
            return this.delegate().open(objectIds, reportMissing);
        }

        @Override
        public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.delegate().getObjectSize(objectId, typeHint);
        }

        @Override
        public <T extends ObjectId> AsyncObjectSizeQueue<T> getObjectSize(Iterable<T> objectIds, boolean reportMissing) {
            return this.delegate().getObjectSize(objectIds, reportMissing);
        }

        @Override
        public void setAvoidUnreachableObjects(boolean avoid) {
            this.delegate().setAvoidUnreachableObjects(avoid);
        }

        @Override
        public BitmapIndex getBitmapIndex() throws IOException {
            return this.delegate().getBitmapIndex();
        }

        @Override
        @Nullable
        public ObjectInserter getCreatedFromInserter() {
            return this.delegate().getCreatedFromInserter();
        }

        @Override
        public void close() {
            this.delegate().close();
        }
    }
}

