/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.issues;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;
import se.bjurr.gitchangelog.internal.settings.CustomIssue;
import se.bjurr.gitchangelog.internal.settings.Settings;

public class IssueParser {
    private final List<GitCommit> commits;
    private final Settings settings;

    public IssueParser(Settings settings, List<GitCommit> commits) {
        this.settings = settings;
        this.commits = commits;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public List<GitCommit> getCommits() {
        return this.commits;
    }

    public List<ParsedIssue> parseForIssues() {
        HashMap foundIssues = Maps.newHashMap();
        ArrayList patterns = Lists.newArrayList(this.settings.getCustomIssues());
        if (this.settings.getGithubIssuePattern().isPresent()) {
            patterns.add(new CustomIssue("Github", (String)this.settings.getGithubIssuePattern().get(), (String)this.settings.getGithubServer().orNull()));
        }
        if (this.settings.getJiraIssuePattern().isPresent()) {
            patterns.add(new CustomIssue("Jira", (String)this.settings.getJiraIssuePattern().get(), (String)this.settings.getJiraServer().orNull()));
        }
        for (GitCommit gitCommit : this.commits) {
            boolean commitMappedToIssue = false;
            for (CustomIssue issuePattern : patterns) {
                Matcher matcher = Pattern.compile(issuePattern.getPattern()).matcher(gitCommit.getMessage());
                if (!matcher.find()) continue;
                String matched = matcher.group();
                if (!foundIssues.containsKey(matched)) {
                    foundIssues.put(matched, new ParsedIssue(issuePattern.getName(), matched, ((String)issuePattern.getLink().or((Object)"")).replaceAll("\\$\\{PATTERN_GROUP\\}", matched)));
                }
                ((ParsedIssue)foundIssues.get(matched)).addCommit(gitCommit);
                commitMappedToIssue = true;
            }
            if (commitMappedToIssue) continue;
            ParsedIssue noIssue = new ParsedIssue(this.settings.getNoIssueName(), null, null);
            if (!foundIssues.containsKey(noIssue.getName())) {
                foundIssues.put(noIssue.getName(), noIssue);
            }
            ((ParsedIssue)foundIssues.get(noIssue.getName())).addCommit(gitCommit);
        }
        return Ordering.usingToString().sortedCopy(foundIssues.values());
    }
}

