/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.model;

import com.google.common.base.Preconditions;
import java.util.List;
import se.bjurr.gitchangelog.api.model.Author;
import se.bjurr.gitchangelog.api.model.Commit;
import se.bjurr.gitchangelog.api.model.Issue;
import se.bjurr.gitchangelog.api.model.interfaces.IAuthors;
import se.bjurr.gitchangelog.api.model.interfaces.ICommits;
import se.bjurr.gitchangelog.api.model.interfaces.IIssues;

public class Tag
implements ICommits,
IAuthors,
IIssues {
    private final List<Commit> commits;
    private final List<Author> authors;
    private final List<Issue> issues;
    private final String name;

    public Tag(String name, List<Commit> commits, List<Author> authors, List<Issue> issues) {
        Preconditions.checkArgument((!commits.isEmpty() ? 1 : 0) != 0, (Object)"commits is empty!");
        Preconditions.checkArgument((!authors.isEmpty() ? 1 : 0) != 0, (Object)"authors is empty!");
        this.commits = commits;
        this.authors = authors;
        this.issues = issues;
        this.name = name;
    }

    @Override
    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    public List<Author> getAuthors() {
        return this.authors;
    }

    public String getName() {
        return this.name;
    }

    public Commit getCommit() {
        return this.commits.get(0);
    }

    @Override
    public List<Commit> getCommits() {
        return this.commits;
    }
}

