/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import se.bjurr.gitchangelog.api.model.Author;
import se.bjurr.gitchangelog.api.model.Commit;
import se.bjurr.gitchangelog.api.model.interfaces.IAuthors;
import se.bjurr.gitchangelog.api.model.interfaces.ICommits;

public class Issue
implements ICommits,
IAuthors {
    private final String name;
    private final String issue;
    private final String link;
    private final List<Commit> commits;
    private final List<Author> authors;

    public Issue(List<Commit> commits, List<Author> authors, String name, String issue, String link) {
        Preconditions.checkState((!commits.isEmpty() ? 1 : 0) != 0, (Object)"commits");
        this.commits = commits;
        this.authors = (List)Preconditions.checkNotNull(authors, (Object)"authors");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.issue = issue;
        this.link = Strings.nullToEmpty((String)link);
    }

    public String getIssue() {
        return this.issue;
    }

    public String getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<Author> getAuthors() {
        return this.authors;
    }

    @Override
    public List<Commit> getCommits() {
        return this.commits;
    }
}

