/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import se.softhouse.jargo.Argument;

@Immutable
public final class ParsedArguments {
    @Nonnull
    private final Map<Argument<?>, Object> parsedArguments = Maps.newLinkedHashMap();
    @Nonnull
    private final Set<Argument<?>> allArguments;
    private int indexedArgumentsParsed = 0;

    ParsedArguments(Set<Argument<?>> arguments) {
        this.allArguments = arguments;
    }

    @Nullable
    @CheckReturnValue
    public <T> T get(Argument<T> argumentToFetch) {
        if (!this.wasGiven(argumentToFetch)) {
            Preconditions.checkArgument((boolean)this.allArguments.contains(argumentToFetch), (String)"%s was not found in this result at all. Did you perhaps forget to add it to withArguments(...)?", (Object[])new Object[]{argumentToFetch});
            return argumentToFetch.defaultValue();
        }
        return this.getValue(argumentToFetch);
    }

    public boolean wasGiven(Argument<?> argument) {
        return this.parsedArguments.containsKey(Preconditions.checkNotNull(argument));
    }

    public String toString() {
        return this.parsedArguments.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParsedArguments)) {
            return false;
        }
        return this.parsedArguments.equals(((ParsedArguments)other).parsedArguments);
    }

    public int hashCode() {
        return this.parsedArguments.hashCode();
    }

    <T> void put(Argument<T> definition, @Nullable T value) {
        if (definition.isIndexed()) {
            ++this.indexedArgumentsParsed;
        }
        this.parsedArguments.put(definition, value);
    }

    <T> void finalize(Argument<T> definition) {
        T value = this.getValue(definition);
        Object finalizedValue = definition.finalizer().apply(value);
        this.put(definition, finalizedValue);
    }

    <T> T getValue(Argument<T> definition) {
        Object value = this.parsedArguments.get(definition);
        return (T)value;
    }

    Collection<Argument<?>> requiredArgumentsLeft() {
        return Collections2.filter(this.allArguments, (Predicate)Predicates.and((Predicate)Predicates.not((Predicate)Predicates.in(this.parsedArguments.keySet())), Argument.IS_REQUIRED));
    }

    int indexedArgumentsParsed() {
        return this.indexedArgumentsParsed;
    }

    Set<Argument<?>> parsedArguments() {
        return this.parsedArguments.keySet();
    }

    Set<String> nonParsedArguments() {
        HashSet validArguments = Sets.newHashSetWithExpectedSize((int)this.allArguments.size());
        for (Argument<?> argument : this.allArguments) {
            boolean wasGiven = this.wasGiven(argument);
            if (wasGiven && !argument.isAllowedToRepeat()) continue;
            for (String name : argument.names()) {
                if (argument.separator().equals(" ") || argument.isPropertyMap()) {
                    validArguments.add(name);
                    continue;
                }
                validArguments.add(name + argument.separator());
            }
        }
        return validArguments;
    }
}

