/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import se.softhouse.common.collections.CharacterTrie;
import se.softhouse.common.guavaextensions.Preconditions2;
import se.softhouse.common.strings.Describables;
import se.softhouse.common.strings.StringsUtil;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.ArgumentExceptions;
import se.softhouse.jargo.Command;
import se.softhouse.jargo.CommandLineParser;
import se.softhouse.jargo.ParsedArguments;
import se.softhouse.jargo.ProgramInformation;
import se.softhouse.jargo.StringParsers;
import se.softhouse.jargo.Usage;
import se.softhouse.jargo.internal.Texts;

@Immutable
final class CommandLineParserInstance {
    @Nonnull
    private final List<Argument<?>> indexedArguments;
    @Nonnull
    private final NamedArguments namedArguments;
    @Nonnull
    private final SpecialArguments specialArguments;
    @Nonnull
    private final Map<String, Argument<?>> helpArguments;
    @Nonnull
    private final Set<Argument<?>> allArguments;
    private final boolean isCommandParser;
    private final ProgramInformation programInformation;
    private final Locale locale;
    private static final int ONLY_REALLY_CLOSE_MATCHES = 4;
    private static final Joiner NEW_LINE_AND_TAB = Joiner.on((String)(StringsUtil.NEWLINE + '\t'));

    CommandLineParserInstance(Iterable<Argument<?>> argumentDefinitions, ProgramInformation information, Locale locale, boolean isCommandParser) {
        int nrOfArgumentsToHandle = Iterables.size(argumentDefinitions);
        this.indexedArguments = Lists.newArrayListWithCapacity((int)nrOfArgumentsToHandle);
        this.namedArguments = new NamedArguments(nrOfArgumentsToHandle);
        this.specialArguments = new SpecialArguments();
        this.helpArguments = Maps.newHashMap();
        this.allArguments = Sets.newLinkedHashSetWithExpectedSize((int)nrOfArgumentsToHandle);
        this.programInformation = information;
        this.locale = locale;
        this.isCommandParser = isCommandParser;
        for (Argument<?> definition : argumentDefinitions) {
            this.addArgumentDefinition(definition);
        }
        this.verifyThatIndexedAndRequiredArgumentsWasGivenBeforeAnyOptionalArguments();
        this.verifyUniqueMetasForRequiredAndIndexedArguments();
        this.verifyThatOnlyOneArgumentIsOfVariableArity();
    }

    CommandLineParserInstance(Iterable<Argument<?>> argumentDefinitions) {
        this(argumentDefinitions, ProgramInformation.AUTO, CommandLineParser.US_BY_DEFAULT, false);
    }

    private void addArgumentDefinition(Argument<?> definition) {
        if (definition.isIndexed()) {
            this.indexedArguments.add(definition);
        } else {
            for (String name : definition.names()) {
                this.addNamedArgumentDefinition(name, definition);
            }
        }
        boolean added = this.allArguments().add(definition);
        Preconditions.checkArgument((boolean)added, (String)"%s handles the same argument twice", (Object[])new Object[]{definition});
    }

    private void addNamedArgumentDefinition(String name, Argument<?> definition) {
        Argument<?> oldDefinition = null;
        String separator = definition.separator();
        oldDefinition = definition.isPropertyMap() ? this.specialArguments.put(name, definition) : (separator.equals(" ") ? this.namedArguments.put(name, definition) : this.specialArguments.put(name + separator, definition));
        if (definition.isHelpArgument()) {
            this.helpArguments.put(name, definition);
        }
        Preconditions.checkArgument((oldDefinition == null ? 1 : 0) != 0, (String)"%s is handled by several arguments", (Object[])new Object[]{name});
    }

    private void verifyThatIndexedAndRequiredArgumentsWasGivenBeforeAnyOptionalArguments() {
        int lastRequiredIndexedArgument = 0;
        int firstOptionalIndexedArgument = Integer.MAX_VALUE;
        for (int i = 0; i < this.indexedArguments.size(); ++i) {
            Argument<?> indexedArgument = this.indexedArguments.get(i);
            if (indexedArgument.isRequired()) {
                lastRequiredIndexedArgument = i;
                continue;
            }
            if (firstOptionalIndexedArgument != Integer.MAX_VALUE) continue;
            firstOptionalIndexedArgument = i;
        }
        Preconditions.checkArgument((lastRequiredIndexedArgument <= firstOptionalIndexedArgument ? 1 : 0) != 0, (String)"Argument given at index %s is optional but argument at index %s is required. Required arguments must be given before any optional arguments, at least when they are indexed (without names)", (Object[])new Object[]{firstOptionalIndexedArgument, lastRequiredIndexedArgument});
    }

    private void verifyUniqueMetasForRequiredAndIndexedArguments() {
        HashSet metasForRequiredAndIndexedArguments = Sets.newHashSetWithExpectedSize((int)this.indexedArguments.size());
        for (Argument indexedArgument : Collections2.filter(this.indexedArguments, Argument.IS_REQUIRED)) {
            String meta = indexedArgument.metaDescriptionInRightColumn();
            boolean metaWasUnique = metasForRequiredAndIndexedArguments.add(meta);
            Preconditions.checkArgument((boolean)metaWasUnique, (String)"Several required & indexed arguments have the same meta description (%s). That's not allowed because if one of them were left out the user would be confused about which of them he forgot.", (Object[])new Object[]{meta});
        }
    }

    private void verifyThatOnlyOneArgumentIsOfVariableArity() {
        Collection indexedVariableArityArguments = Collections2.filter(this.indexedArguments, Argument.IS_OF_VARIABLE_ARITY);
        Preconditions.checkArgument((indexedVariableArityArguments.size() <= 1 ? 1 : 0) != 0, (String)"Several unnamed arguments are configured to receive a variable arity of parameters: %s", (Object[])new Object[]{indexedVariableArityArguments});
    }

    @Nonnull
    ParsedArguments parse(Iterable<String> actualArguments) throws ArgumentException {
        ArgumentIterator arguments = ArgumentIterator.forArguments(actualArguments, this.helpArguments);
        return this.parse(arguments, this.locale());
    }

    @Nonnull
    ParsedArguments parse(ArgumentIterator arguments, Locale inLocale) throws ArgumentException {
        ParsedArguments holder = this.parseArguments(arguments, inLocale);
        Collection<Argument<?>> missingArguments = holder.requiredArgumentsLeft();
        if (missingArguments.size() > 0) {
            throw ArgumentExceptions.forMissingArguments(missingArguments).withUsage(this.usage(inLocale));
        }
        for (Argument<?> arg : holder.parsedArguments()) {
            holder.finalize(arg);
            this.limitArgument(arg, holder, inLocale);
        }
        if (!this.isCommandParser()) {
            arguments.executeLastCommand();
        }
        return holder;
    }

    private ParsedArguments parseArguments(ArgumentIterator iterator, Locale inLocale) throws ArgumentException {
        ParsedArguments holder = new ParsedArguments(this.allArguments());
        iterator.setCurrentParser(this);
        while (iterator.hasNext()) {
            Argument<?> definition = null;
            try {
                iterator.setCurrentArgumentName(iterator.next());
                definition = this.getDefinitionForCurrentArgument(iterator, holder);
                if (definition == null) break;
                this.parseArgument(iterator, holder, definition, inLocale);
            }
            catch (ArgumentException e) {
                e.withUsedArgumentName(iterator.getCurrentArgumentName());
                if (definition != null) {
                    e.withUsageReference(definition);
                }
                throw e.withUsage(this.usage(inLocale));
            }
        }
        return holder;
    }

    private <T> void parseArgument(ArgumentIterator arguments, ParsedArguments parsedArguments, Argument<T> definition, Locale inLocale) throws ArgumentException {
        if (parsedArguments.wasGiven(definition) && !definition.isAllowedToRepeat() && !definition.isPropertyMap()) {
            throw ArgumentExceptions.forUnallowedRepetitionArgument(arguments.current());
        }
        StringParsers.InternalStringParser<T> parser = definition.parser();
        T oldValue = parsedArguments.getValue(definition);
        T parsedValue = parser.parse(arguments, oldValue, definition, inLocale);
        parsedArguments.put(definition, parsedValue);
    }

    @Nullable
    private Argument<?> getDefinitionForCurrentArgument(ArgumentIterator iterator, ParsedArguments holder) throws ArgumentException {
        Argument<?> indexedArgument;
        if (iterator.allowsOptions()) {
            Argument<?> byName = this.lookupByName(iterator);
            if (byName != null) {
                return byName;
            }
            Argument<?> option = this.batchOfShortNamedArguments(iterator, holder);
            if (option != null) {
                return option;
            }
        }
        if ((indexedArgument = this.indexedArgument(iterator, holder)) != null) {
            return indexedArgument;
        }
        if (this.isCommandParser()) {
            iterator.previous();
            return null;
        }
        this.guessAndSuggestIfCloseMatch(iterator, holder);
        throw ArgumentExceptions.forUnexpectedArgument(iterator);
    }

    private Argument<?> lookupByName(ArgumentIterator arguments) {
        String currentArgument = arguments.current();
        Argument<?> definition = this.namedArguments.get(currentArgument);
        if (definition != null) {
            return definition;
        }
        Map.Entry<String, Argument<?>> entry = this.specialArguments.get(currentArgument);
        if (entry != null) {
            String valueAfterSeparator = currentArgument.substring(entry.getKey().length());
            arguments.setNextArgumentTo(valueAfterSeparator);
            return entry.getValue();
        }
        definition = arguments.helpArgument(currentArgument);
        return definition;
    }

    private Argument<?> batchOfShortNamedArguments(ArgumentIterator arguments, ParsedArguments holder) throws ArgumentException {
        String currentArgument = arguments.current();
        if (StringsUtil.startsWithAndHasMore(currentArgument, "-")) {
            ImmutableList givenCharacters = Lists.charactersOf((String)currentArgument.substring(1));
            LinkedHashSet foundOptions = Sets.newLinkedHashSetWithExpectedSize((int)givenCharacters.size());
            Argument<?> lastOption = null;
            for (Character optionName : givenCharacters) {
                lastOption = this.namedArguments.get("-" + optionName);
                if (lastOption != null && lastOption.parser().parameterArity() == Argument.ParameterArity.NO_ARGUMENTS && foundOptions.add(lastOption)) continue;
                break;
            }
            if (foundOptions.size() == givenCharacters.size()) {
                foundOptions.remove(lastOption);
                for (Argument option : foundOptions) {
                    this.parseArgument(arguments, holder, option, null);
                }
                return lastOption;
            }
        }
        return null;
    }

    private Argument<?> indexedArgument(ArgumentIterator arguments, ParsedArguments holder) {
        if (holder.indexedArgumentsParsed() < this.indexedArguments.size()) {
            Argument<?> definition = this.indexedArguments.get(holder.indexedArgumentsParsed());
            arguments.previous();
            if (this.isCommandParser()) {
                arguments.setCurrentArgumentName(arguments.usedCommandName());
            } else {
                arguments.setCurrentArgumentName(definition.metaDescriptionInRightColumn());
            }
            return definition;
        }
        return null;
    }

    private void guessAndSuggestIfCloseMatch(ArgumentIterator arguments, ParsedArguments holder) throws ArgumentException {
        List<String> suggestions;
        Sets.SetView availableArguments = Sets.union(holder.nonParsedArguments(), arguments.nonParsedArguments());
        if (!availableArguments.isEmpty() && !(suggestions = StringsUtil.closestMatches(arguments.current(), (Iterable<String>)availableArguments, 4)).isEmpty()) {
            throw ArgumentExceptions.withMessage(Describables.format(Texts.UserErrors.SUGGESTION, arguments.current(), NEW_LINE_AND_TAB.join(suggestions)));
        }
    }

    private <T> void limitArgument(@Nonnull Argument<T> arg, ParsedArguments holder, Locale inLocale) throws ArgumentException {
        try {
            arg.checkLimit(holder.getValue(arg));
        }
        catch (IllegalArgumentException e) {
            throw ArgumentExceptions.wrapException(e).withUsageReference(arg).withUsedArgumentName(arg.toString()).withUsage(this.usage(inLocale));
        }
        catch (ArgumentException e) {
            throw e.withUsageReference(arg).withUsage(this.usage(inLocale));
        }
    }

    boolean isCommandParser() {
        return this.isCommandParser;
    }

    Set<Argument<?>> allArguments() {
        return this.allArguments;
    }

    ProgramInformation programInformation() {
        return this.programInformation;
    }

    Locale locale() {
        return this.locale;
    }

    @CheckReturnValue
    @Nonnull
    Usage usage(Locale inLocale) {
        return new Usage(this.allArguments(), inLocale, this.programInformation(), this.isCommandParser());
    }

    @CheckReturnValue
    @Nonnull
    ArgumentException helpFor(ArgumentIterator arguments, Locale inLocale) throws ArgumentException {
        ArgumentException e = ArgumentExceptions.withMessage("Help requested with " + arguments.current());
        Usage usage = null;
        if (arguments.hasNext()) {
            arguments.next();
            Argument<?> argument = this.lookupByName(arguments);
            if (argument == null) {
                throw ArgumentExceptions.withMessage(Describables.format("'%s' is not a supported argument/option/command", arguments.current()));
            }
            usage = new Usage(Arrays.asList(argument), inLocale, this.programInformation(), this.isCommandParser());
            if (this.isCommandParser()) {
                String withCommandReference = ". Usage for " + argument + " (argument to " + arguments.usedCommandName() + "):";
                e.withUsageReference(withCommandReference);
            } else {
                e.withUsageReference(argument);
            }
        } else {
            usage = this.usage(inLocale);
            if (this.isCommandParser()) {
                e.withUsageReference(". See usage for " + arguments.usedCommandName() + " below:");
            } else {
                e.withUsageReference(". See usage below:");
            }
        }
        return e.withUsage(usage);
    }

    public String toString() {
        return this.usage(this.locale()).toString();
    }

    private static final class SpecialArguments {
        private final CharacterTrie<Argument<?>> specialArguments = CharacterTrie.newTrie();

        SpecialArguments() {
        }

        Argument<?> put(String name, Argument<?> definition) {
            if (definition.isIgnoringCase()) {
                return this.specialArguments.put(name.toLowerCase(Locale.ENGLISH), definition);
            }
            return this.specialArguments.put(name, definition);
        }

        Map.Entry<String, Argument<?>> get(String name) {
            Map.Entry<String, Argument<?>> entry = this.specialArguments.findLongestPrefix(name);
            if (entry != null) {
                return entry;
            }
            String lowerCase = name.toLowerCase(Locale.ENGLISH);
            entry = this.specialArguments.findLongestPrefix(lowerCase);
            if (entry != null && entry.getValue().isIgnoringCase()) {
                return entry;
            }
            return null;
        }
    }

    private static final class NamedArguments {
        private final Map<String, Argument<?>> namedArguments;

        NamedArguments(int expectedSize) {
            this.namedArguments = Maps.newHashMapWithExpectedSize((int)expectedSize);
        }

        Argument<?> put(String name, Argument<?> definition) {
            if (definition.isIgnoringCase()) {
                return this.namedArguments.put(name.toLowerCase(Locale.ENGLISH), definition);
            }
            return this.namedArguments.put(name, definition);
        }

        Argument<?> get(String name) {
            Argument<?> definition = this.namedArguments.get(name);
            if (definition != null) {
                return definition;
            }
            String lowerCase = name.toLowerCase(Locale.ENGLISH);
            definition = this.namedArguments.get(lowerCase);
            if (definition != null && definition.isIgnoringCase()) {
                return definition;
            }
            return null;
        }
    }

    @NotThreadSafe
    static final class ArgumentIterator
    extends UnmodifiableIterator<String> {
        private final List<String> arguments;
        private String currentArgumentName;
        private int currentArgumentIndex;
        private boolean endOfOptionsReceived;
        private int indexOfLastCommand = -1;
        private Command lastCommandParsed;
        private ParsedArguments argumentsToLastCommand;
        private CommandLineParserInstance currentParser;
        private final Map<String, Argument<?>> helpArguments;

        private ArgumentIterator(Iterable<String> actualArguments, Map<String, Argument<?>> helpArguments) {
            this.arguments = Preconditions2.checkNulls(actualArguments, "Argument strings may not be null");
            this.helpArguments = helpArguments;
        }

        Argument<?> helpArgument(String currentArgument) {
            return this.helpArguments.get(currentArgument);
        }

        boolean allowsOptions() {
            return !this.endOfOptionsReceived;
        }

        void setCurrentParser(CommandLineParserInstance instance) {
            this.currentParser = instance;
        }

        void rememberAsCommand() {
            this.executeLastCommand();
            this.indexOfLastCommand = this.currentArgumentIndex - 1;
        }

        void rememberInvocationOfCommand(Command command, ParsedArguments argumentsToCommand) {
            this.executeLastCommand();
            this.lastCommandParsed = command;
            this.argumentsToLastCommand = argumentsToCommand;
        }

        void executeLastCommand() {
            if (this.lastCommandParsed != null) {
                this.lastCommandParsed.execute(this.argumentsToLastCommand);
                this.lastCommandParsed = null;
            }
        }

        Set<String> nonParsedArguments() {
            if (this.lastCommandParsed != null) {
                return this.argumentsToLastCommand.nonParsedArguments();
            }
            return Collections.emptySet();
        }

        String usedCommandName() {
            return this.arguments.get(this.indexOfLastCommand);
        }

        static ArgumentIterator forArguments(Iterable<String> arguments, Map<String, Argument<?>> helpArguments) {
            return new ArgumentIterator(arguments, helpArguments);
        }

        static ArgumentIterator forArguments(Iterable<String> arguments) {
            return new ArgumentIterator(arguments, Collections.<String, Argument<?>>emptyMap());
        }

        String current() {
            return this.arguments.get(this.currentArgumentIndex - 1);
        }

        public boolean hasNext() {
            return this.currentArgumentIndex < this.arguments.size();
        }

        public String next() {
            String nextArgument = this.arguments.get(this.currentArgumentIndex++);
            nextArgument = this.skipAheadIfEndOfOptions(nextArgument);
            nextArgument = this.readArgumentsFromFile(nextArgument);
            return nextArgument;
        }

        private String skipAheadIfEndOfOptions(String nextArgument) {
            if (!this.endOfOptionsReceived && nextArgument.equals("--")) {
                this.endOfOptionsReceived = true;
                return this.next();
            }
            return nextArgument;
        }

        private String readArgumentsFromFile(String nextArgument) {
            String filename;
            File fileWithArguments;
            if (nextArgument.startsWith("@") && (fileWithArguments = new File(filename = nextArgument.substring(1))).exists()) {
                try {
                    this.appendArgumentsAtCurrentPosition(Files.readLines((File)fileWithArguments, (Charset)Charsets.UTF_8));
                }
                catch (IOException errorWhileReadingFile) {
                    throw ArgumentExceptions.withMessage("Failed while reading arguments from: " + filename, (Throwable)errorWhileReadingFile);
                }
                return this.next();
            }
            return nextArgument;
        }

        private void appendArgumentsAtCurrentPosition(List<String> argumentsToAppend) {
            this.arguments.addAll(this.currentArgumentIndex, argumentsToAppend);
        }

        public String toString() {
            return this.arguments.subList(this.currentArgumentIndex, this.arguments.size()).toString();
        }

        String previous() {
            return this.arguments.get(--this.currentArgumentIndex);
        }

        int nrOfRemainingArguments() {
            return this.arguments.size() - this.currentArgumentIndex;
        }

        void setNextArgumentTo(String newNextArgumentString) {
            this.arguments.set(--this.currentArgumentIndex, newNextArgumentString);
        }

        boolean hasPrevious() {
            return this.currentArgumentIndex > 0;
        }

        void setCurrentArgumentName(String argumentName) {
            this.currentArgumentName = argumentName;
        }

        String getCurrentArgumentName() {
            return this.currentArgumentName;
        }

        CommandLineParserInstance currentParser() {
            return this.currentParser;
        }
    }
}

