/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import se.softhouse.common.guavaextensions.Functions2;
import se.softhouse.common.guavaextensions.Predicates2;
import se.softhouse.common.strings.Describable;
import se.softhouse.common.strings.Describables;
import se.softhouse.common.strings.Describer;
import se.softhouse.common.strings.Describers;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.Command;
import se.softhouse.jargo.ParsedArguments;
import se.softhouse.jargo.StringParser;
import se.softhouse.jargo.StringParsers;
import se.softhouse.jargo.Usage;

@NotThreadSafe
public abstract class ArgumentBuilder<SELF extends ArgumentBuilder<SELF, T>, T> {
    static final String DEFAULT_SEPARATOR = " ";
    @Nonnull
    private List<String> names = Collections.emptyList();
    @Nonnull
    private Describable description = Describables.EMPTY_STRING;
    private boolean required = false;
    @Nonnull
    private String separator = " ";
    private boolean ignoreCase = false;
    private boolean isAllowedToRepeat = false;
    @Nonnull
    private Optional<String> metaDescription = Optional.absent();
    private boolean hideFromUsage = false;
    private boolean isPropertyMap = false;
    @Nullable
    private Supplier<? extends T> defaultValueSupplier = null;
    @Nullable
    private Describer<? super T> defaultValueDescriber = null;
    @Nonnull
    private Function<T, T> finalizer = Functions.identity();
    @Nonnull
    private Predicate<? super T> limiter = Predicates.alwaysTrue();
    @Nullable
    private final StringParsers.InternalStringParser<T> internalStringParser;
    @Nonnull
    private final SELF myself;

    protected ArgumentBuilder() {
        this(null);
    }

    ArgumentBuilder(StringParsers.InternalStringParser<T> stringParser) {
        this.internalStringParser = stringParser;
        this.myself = this.self();
    }

    private SELF self() {
        return (SELF)this;
    }

    @CheckReturnValue
    @Nonnull
    public final Argument<T> build() {
        return new Argument(this);
    }

    @Nullable
    public final T parse(String ... actualArguments) throws ArgumentException {
        return this.build().parse(actualArguments);
    }

    public final Usage usage() {
        return this.build().usage();
    }

    @Nonnull
    protected abstract StringParser<T> parser();

    @Nonnull
    StringParsers.InternalStringParser<T> internalParser() {
        StringParser<T> parser = this.parser();
        if (parser != InternalArgumentBuilder.MARKER) {
            return new StringParsers.StringParserBridge<T>(parser);
        }
        return this.internalStringParser;
    }

    public SELF names(String ... argumentNames) {
        this.checkNoSpaces(Arrays.asList(argumentNames));
        this.names = ImmutableList.copyOf((Object[])argumentNames);
        return this.myself;
    }

    public SELF names(Iterable<String> argumentNames) {
        this.checkNoSpaces(argumentNames);
        this.names = ImmutableList.copyOf(argumentNames);
        return this.myself;
    }

    public final SELF ignoreCase() {
        this.ignoreCase = true;
        return this.myself;
    }

    public final SELF description(String theDescription) {
        this.description = Describables.withString(theDescription);
        return this.myself;
    }

    public final SELF description(Describable theDescription) {
        this.description = (Describable)Preconditions.checkNotNull((Object)theDescription);
        return this.myself;
    }

    public SELF required() {
        Preconditions.checkState((this.defaultValueSupplier == null ? 1 : 0) != 0, (Object)"Having a requried argument and a default value makes no sense");
        this.required = true;
        return this.myself;
    }

    public SELF defaultValue(@Nullable T value) {
        Preconditions.checkState((!this.required ? 1 : 0) != 0, (Object)"Having a requried argument and a default value makes no sense");
        this.defaultValueSupplier = Suppliers.ofInstance(value);
        return this.myself;
    }

    @Beta
    public SELF defaultValueSupplier(Supplier<? extends T> aDefaultValueSupplier) {
        Preconditions.checkState((!this.required ? 1 : 0) != 0, (Object)"Having a requried argument and a default value makes no sense");
        this.defaultValueSupplier = (Supplier)Preconditions.checkNotNull(aDefaultValueSupplier);
        return this.myself;
    }

    public SELF defaultValueDescription(String aDescription) {
        this.defaultValueDescriber = Describers.withConstantString(aDescription);
        return this.myself;
    }

    public SELF defaultValueDescriber(Describer<? super T> describer) {
        this.defaultValueDescriber = (Describer)Preconditions.checkNotNull(describer);
        return this.myself;
    }

    public final SELF metaDescription(String aMetaDescription) {
        Preconditions.checkArgument((aMetaDescription.length() > 0 ? 1 : 0) != 0, (Object)"a meta description can't be empty");
        this.metaDescription = Optional.of((Object)aMetaDescription);
        return this.myself;
    }

    public final SELF hideFromUsage() {
        this.hideFromUsage = true;
        return this.myself;
    }

    public SELF separator(String aSeparator) {
        this.separator = (String)Preconditions.checkNotNull((Object)aSeparator);
        return this.myself;
    }

    @Beta
    public SELF limitTo(Predicate<? super T> aLimiter) {
        this.limiter = Predicates2.and(this.limiter, aLimiter);
        return this.myself;
    }

    @CheckReturnValue
    public final MapArgumentBuilder<String, T> asPropertyMap() {
        return new MapArgumentBuilder(this, StringParsers.stringParser());
    }

    @CheckReturnValue
    public final <K> MapArgumentBuilder<K, T> asKeyValuesWithKeyParser(StringParser<K> keyParser) {
        return new MapArgumentBuilder(this, (StringParser)Preconditions.checkNotNull(keyParser));
    }

    @CheckReturnValue
    public SplitterArgumentBuilder<T> splitWith(String valueSeparator) {
        return new SplitterArgumentBuilder(this, valueSeparator);
    }

    @CheckReturnValue
    public ArityArgumentBuilder<T> variableArity() {
        return new ArityArgumentBuilder(this);
    }

    @CheckReturnValue
    public ArityArgumentBuilder<T> arity(int numberOfParameters) {
        Preconditions.checkArgument((numberOfParameters > 1 ? 1 : 0) != 0, (String)"Arity requires at least 2 parameters (got %s)", (Object[])new Object[]{numberOfParameters});
        return new ArityArgumentBuilder(this, numberOfParameters);
    }

    @CheckReturnValue
    public RepeatedArgumentBuilder<T> repeated() {
        return new RepeatedArgumentBuilder(this);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("names", this.names).add("description", (Object)this.description).add("metaDescription", this.metaDescription).add("hideFromUsage", this.hideFromUsage).add("ignoreCase", this.ignoreCase).add("limiter", this.limiter).add("required", this.required).add("separator", (Object)this.separator).add("defaultValueDescriber", this.defaultValueDescriber).add("defaultValueSupplier", this.defaultValueSupplier).add("internalStringParser", this.internalStringParser).toString();
    }

    @OverridingMethodsMustInvokeSuper
    void copy(ArgumentBuilder<?, ?> copy) {
        this.names = copy.names;
        this.description = copy.description;
        this.required = copy.required;
        this.separator = copy.separator;
        this.ignoreCase = copy.ignoreCase;
        this.isAllowedToRepeat = copy.isAllowedToRepeat;
        this.metaDescription = copy.metaDescription;
        this.hideFromUsage = copy.hideFromUsage;
    }

    final SELF finalizeWith(Function<T, T> aFinalizer) {
        this.finalizer = Functions2.compound(this.finalizer, aFinalizer);
        return this.myself;
    }

    final void allowRepeatedArguments() {
        this.isAllowedToRepeat = true;
    }

    final void setAsPropertyMap() {
        this.isPropertyMap = true;
    }

    @Nonnull
    final List<String> names() {
        return this.names;
    }

    @Nullable
    Describer<? super T> defaultValueDescriber() {
        return this.defaultValueDescriber;
    }

    @Nonnull
    Describable description() {
        return this.description;
    }

    final boolean isRequired() {
        return this.required;
    }

    @Nullable
    final String separator() {
        return this.separator;
    }

    final boolean isIgnoringCase() {
        return this.ignoreCase;
    }

    final boolean isPropertyMap() {
        return this.isPropertyMap;
    }

    final boolean isAllowedToRepeat() {
        return this.isAllowedToRepeat;
    }

    @Nullable
    final Optional<String> metaDescription() {
        return this.metaDescription;
    }

    final boolean isHiddenFromUsage() {
        return this.hideFromUsage;
    }

    @Nullable
    final Supplier<? extends T> defaultValueSupplier() {
        return this.defaultValueSupplier;
    }

    @Nonnull
    final Function<T, T> finalizer() {
        return this.finalizer;
    }

    @Nonnull
    final Predicate<? super T> limiter() {
        return this.limiter;
    }

    private void checkNoSpaces(Iterable<String> argumentNames) {
        for (String name : argumentNames) {
            Preconditions.checkArgument((!name.contains(DEFAULT_SEPARATOR) ? 1 : 0) != 0, (String)"Detected a space in %s, argument names must not have spaces in them", (Object[])new Object[]{name});
        }
    }

    static /* synthetic */ Function access$500(ArgumentBuilder x0) {
        return x0.finalizer;
    }

    static /* synthetic */ Describer access$800(ArgumentBuilder x0) {
        return x0.defaultValueDescriber;
    }

    @NotThreadSafe
    public static final class SplitterArgumentBuilder<T>
    extends ListArgumentBuilder<SplitterArgumentBuilder<T>, T> {
        private SplitterArgumentBuilder(ArgumentBuilder<?, T> builder, String valueSeparator) {
            super(new StringParsers.StringSplitterParser<T>(valueSeparator, builder.internalParser()));
            this.copy(builder);
            this.copyAsListBuilder(builder, 1);
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<List<T>> arity(int numberOfParameters) {
            throw new IllegalStateException("You can't use both splitWith and arity");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<List<T>> variableArity() {
            throw new IllegalStateException("You can't use both splitWith and variableArity");
        }
    }

    @NotThreadSafe
    public static final class MapArgumentBuilder<K, V>
    extends InternalArgumentBuilder<MapArgumentBuilder<K, V>, Map<K, V>> {
        private final ArgumentBuilder<?, V> valueBuilder;
        private final StringParser<K> keyParser;

        /*
         * Exception decompiling
         */
        private MapArgumentBuilder(ArgumentBuilder<?, V> builder, StringParser<K> keyParser) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        StringParsers.InternalStringParser<Map<K, V>> internalParser() {
            Preconditions.checkState((this.names().size() > 0 ? 1 : 0) != 0, (Object)"No leading identifier (otherwise called names), for example -D, specified for property map. Call names(...) to provide it.");
            if (this.separator().equals(ArgumentBuilder.DEFAULT_SEPARATOR)) {
                this.separator("=");
            } else {
                Preconditions.checkState((this.separator().length() > 0 ? 1 : 0) != 0, (Object)"In a key=value pair a separator of at least one character is required");
            }
            return new StringParsers.KeyValueParser<K, V>(this.keyParser, this.valueBuilder.internalParser(), ((ArgumentBuilder)this.valueBuilder).limiter, this.defaultValueSupplier(), ((ArgumentBuilder)this.valueBuilder).defaultValueSupplier);
        }

        @Override
        Describer<? super Map<K, V>> defaultValueDescriber() {
            Describer overriddenDescriber = super.defaultValueDescriber();
            if (overriddenDescriber != null) {
                return overriddenDescriber;
            }
            Describer<V> valueDescriber = this.valueBuilder.defaultValueDescriber();
            if (valueDescriber != null) {
                Describer mapDescriber = Describers.mapDescriber(valueDescriber, this.separator());
                return mapDescriber;
            }
            return Describers.mapDescriber(Describers.toStringDescriber(), this.separator());
        }

        @Override
        @Deprecated
        public RepeatedArgumentBuilder<Map<K, V>> repeated() {
            throw new IllegalStateException("You'll need to call repeated before asPropertyMap");
        }

        @Override
        @Deprecated
        public SplitterArgumentBuilder<Map<K, V>> splitWith(String valueSeparator) {
            throw new IllegalStateException("You'll need to call splitWith before asPropertyMap");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<Map<K, V>> arity(int nrOfParameters) {
            throw new IllegalStateException("You'll need to call arity before asPropertyMap");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<Map<K, V>> variableArity() {
            throw new IllegalStateException("asPropertyMap is already of variable arity");
        }

        @Override
        public MapArgumentBuilder<K, V> defaultValue(Map<K, V> defaultKeyValues) {
            return (MapArgumentBuilder)super.defaultValue(Maps.newLinkedHashMap(defaultKeyValues));
        }
    }

    @NotThreadSafe
    public static final class OptionArgumentBuilder
    extends InternalArgumentBuilder<OptionArgumentBuilder, Boolean> {
        OptionArgumentBuilder() {
            this.defaultValue(false);
        }

        @Override
        StringParsers.InternalStringParser<Boolean> internalParser() {
            return StringParsers.optionParser((Boolean)this.defaultValueSupplier().get());
        }

        @Override
        public OptionArgumentBuilder defaultValue(@Nonnull Boolean value) {
            Preconditions.checkNotNull((Object)value, (Object)"Null is not allowed as a default value for an option argument. An option is either given or it's not. ");
            return (OptionArgumentBuilder)super.defaultValue(value);
        }

        @Override
        public OptionArgumentBuilder names(Iterable<String> argumentNames) {
            Preconditions.checkArgument((!Iterables.isEmpty(argumentNames) ? 1 : 0) != 0, (Object)"An option requires at least one name, otherwise it wouldn't be useful");
            return (OptionArgumentBuilder)super.names(argumentNames);
        }

        @Override
        public OptionArgumentBuilder names(String ... argumentNames) {
            Preconditions.checkArgument((argumentNames.length >= 1 ? 1 : 0) != 0, (Object)"An option requires at least one name, otherwise it wouldn't be useful");
            return (OptionArgumentBuilder)super.names(argumentNames);
        }

        @Override
        @Deprecated
        public OptionArgumentBuilder required() {
            throw new IllegalStateException("An optional flag can't be requried");
        }

        @Override
        @Deprecated
        public OptionArgumentBuilder separator(String aSeparator) {
            throw new IllegalStateException("A seperator for an optional flag isn't supported as an optional flag can't be assigned a value");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<Boolean> arity(int numberOfParameters) {
            throw new IllegalStateException("An optional flag can't have any other arity than zero");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<Boolean> variableArity() {
            throw new IllegalStateException("An optional flag can't have any other arity than zero");
        }

        @Override
        @Deprecated
        public SplitterArgumentBuilder<Boolean> splitWith(String valueSeparator) {
            throw new IllegalStateException("An optional flag can't be split as it has no value that is parsed");
        }
    }

    @NotThreadSafe
    public static final class RepeatedArgumentBuilder<T>
    extends ListArgumentBuilder<RepeatedArgumentBuilder<T>, T> {
        private RepeatedArgumentBuilder(ArgumentBuilder<? extends ArgumentBuilder<?, T>, T> builder) {
            super(new StringParsers.RepeatedArgumentParser<T>(builder.internalParser()));
            this.copy(builder);
            this.copyAsListBuilder(builder, 1);
            this.allowRepeatedArguments();
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<List<T>> arity(int numberOfParameters) {
            throw new IllegalStateException("Programmer Error. Call arity(...) before repeated()");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<List<T>> variableArity() {
            throw new IllegalStateException("Programmer Error. Call variableArity(...) before repeated()");
        }

        @Override
        @Deprecated
        public SplitterArgumentBuilder<List<T>> splitWith(String valueSeparator) {
            throw new IllegalStateException("call splitWith(String) before repeated()");
        }
    }

    @NotThreadSafe
    public static final class ArityArgumentBuilder<T>
    extends ListArgumentBuilder<ArityArgumentBuilder<T>, T> {
        private ArityArgumentBuilder(ArgumentBuilder<? extends ArgumentBuilder<?, T>, T> builder, int arity) {
            super(new StringParsers.FixedArityParser<T>(builder.internalParser(), arity));
            this.init(builder, arity);
        }

        private ArityArgumentBuilder(ArgumentBuilder<? extends ArgumentBuilder<?, T>, T> builder) {
            super(new StringParsers.VariableArityParser<T>(builder.internalParser()));
            this.init(builder, 1);
        }

        private void init(ArgumentBuilder<? extends ArgumentBuilder<?, T>, T> builder, int nrOfElementsInDefaultValue) {
            this.copy(builder);
            this.copyAsListBuilder(builder, nrOfElementsInDefaultValue);
        }

        @Override
        @Deprecated
        public SplitterArgumentBuilder<List<T>> splitWith(String valueSeparator) {
            throw new IllegalStateException("splitWith(...) doesn't work with arity/variableArity()");
        }
    }

    private static class ListArgumentBuilder<BUILDER extends ListArgumentBuilder<BUILDER, T>, T>
    extends InternalArgumentBuilder<BUILDER, List<T>> {
        ListArgumentBuilder(StringParsers.InternalStringParser<List<T>> parser) {
            super(parser);
        }

        /*
         * Exception decompiling
         */
        void copyAsListBuilder(ArgumentBuilder<?, T> builder, int nrOfElementsInDefaultValue) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @NotThreadSafe
    public static final class CommandBuilder
    extends InternalArgumentBuilder<CommandBuilder, ParsedArguments> {
        CommandBuilder(Command command) {
            super(command);
        }

        @Override
        @Deprecated
        public CommandBuilder required() {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public CommandBuilder defaultValue(ParsedArguments defaultValue) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public CommandBuilder defaultValueSupplier(Supplier<? extends ParsedArguments> defaultValueSupplier) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public CommandBuilder defaultValueDescription(String defaultValueDescription) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public CommandBuilder defaultValueDescriber(Describer<? super ParsedArguments> defaultValueDescriber) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public CommandBuilder limitTo(Predicate<? super ParsedArguments> limiter) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public SplitterArgumentBuilder<ParsedArguments> splitWith(String valueSeparator) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<ParsedArguments> arity(int arity) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<ParsedArguments> variableArity() {
            throw new IllegalStateException();
        }
    }

    static final class SimpleArgumentBuilder<T>
    extends InternalArgumentBuilder<SimpleArgumentBuilder<T>, T> {
        SimpleArgumentBuilder(StringParsers.InternalStringParser<T> parser) {
            super(parser);
        }
    }

    private static abstract class InternalArgumentBuilder<BUILDER extends InternalArgumentBuilder<BUILDER, T>, T>
    extends ArgumentBuilder<BUILDER, T> {
        static final StringParser<?> MARKER = new StringParsers.StringParserBridge<String>(StringParsers.stringParser());

        InternalArgumentBuilder() {
        }

        InternalArgumentBuilder(StringParsers.InternalStringParser<T> parser) {
            super(parser);
        }

        @Override
        protected StringParser<T> parser() {
            return MARKER;
        }
    }

    @NotThreadSafe
    public static final class DefaultArgumentBuilder<T>
    extends ArgumentBuilder<DefaultArgumentBuilder<T>, T> {
        private final StringParser<T> parser;

        DefaultArgumentBuilder(StringParser<T> aParser) {
            this.parser = (StringParser)Preconditions.checkNotNull(aParser);
        }

        @Override
        protected StringParser<T> parser() {
            return this.parser;
        }
    }
}

