/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.strings;

import java.text.BreakIterator;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.strings.StringsUtil;

@Immutable
public final class Lines {
    private Lines() {
    }

    public static StringBuilder wrap(CharSequence value, int maxLineLength, Locale locale) {
        return Lines.wrap(value, 0, maxLineLength, locale);
    }

    public static StringBuilder wrap(CharSequence value, int startingIndex, int maxLineLength, Locale locale) {
        String textToSplit = value.toString();
        StringBuilder result = new StringBuilder(textToSplit.length());
        BreakIterator boundary = BreakIterator.getLineInstance(locale);
        boundary.setText(textToSplit);
        int start = boundary.first();
        int end = boundary.next();
        int lineLength = startingIndex;
        while (end != -1) {
            String word = textToSplit.substring(start, end);
            if ((lineLength += word.length()) >= maxLineLength) {
                result.append(StringsUtil.NEWLINE);
                lineLength = startingIndex;
            }
            result.append(word);
            start = end;
            end = boundary.next();
        }
        return result;
    }
}

