/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.strings;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.strings.Describable;

@Immutable
public final class Describables {
    @Nonnull
    public static final SerializableDescription EMPTY_STRING = Describables.asSerializable(Describables.withString(""));

    private Describables() {
    }

    @Nonnull
    @CheckReturnValue
    public static Describable withString(String description) {
        return new NonLazyDescription(description);
    }

    @Nonnull
    @CheckReturnValue
    public static Describable format(String formatTemplate, Object ... args) {
        return new FormatDescription(formatTemplate, args);
    }

    public static Describable cache(Describable describable) {
        return new CachingDescription((Describable)Preconditions.checkNotNull((Object)describable));
    }

    @Nonnull
    @CheckReturnValue
    public static Describable toString(Object value) {
        return new ToStringDescription(value);
    }

    @Nonnull
    @CheckReturnValue
    public static IllegalArgumentException illegalArgument(Describable message) {
        return new IllegalArgument(message);
    }

    @Nonnull
    @CheckReturnValue
    public static IllegalArgumentException illegalArgument(Describable message, Throwable cause) {
        return new IllegalArgument(message, cause);
    }

    @Nonnull
    @CheckReturnValue
    public static SerializableDescription asSerializable(Describable describable) {
        return new SerializableDescription(describable);
    }

    public static final class SerializableDescription
    implements Serializable,
    Describable {
        private final transient Describable describable;
        private static final long serialVersionUID = 1L;

        private SerializableDescription(Describable descriptionToSerialize) {
            this.describable = (Describable)Preconditions.checkNotNull((Object)descriptionToSerialize);
        }

        Object writeReplace() {
            return new SerializationProxy(this);
        }

        @Override
        public String description() {
            return this.describable.description();
        }

        public String toString() {
            return this.description();
        }

        private static final class SerializationProxy
        implements Serializable {
            private final String message;
            private static final long serialVersionUID = 1L;

            private SerializationProxy(Describable descriptionToSerialize) {
                this.message = descriptionToSerialize.description();
            }

            private Object readResolve() {
                return new SerializableDescription(Describables.withString(this.message));
            }
        }
    }

    private static final class IllegalArgument
    extends IllegalArgumentException {
        private final SerializableDescription message;
        private static final long serialVersionUID = 1L;

        private IllegalArgument(Describable message) {
            this.message = Describables.asSerializable(message);
        }

        private IllegalArgument(Describable message, Throwable cause) {
            this(message);
            this.initCause((Throwable)Preconditions.checkNotNull((Object)cause));
        }

        @Override
        public String getMessage() {
            return this.message.description();
        }
    }

    private static final class ToStringDescription
    implements Describable {
        private final Object value;

        private ToStringDescription(Object value) {
            this.value = Preconditions.checkNotNull((Object)value);
        }

        @Override
        public String description() {
            return this.value.toString();
        }

        public String toString() {
            return this.description();
        }
    }

    private static final class CachingDescription
    implements Describable {
        private final Supplier<String> description;

        private CachingDescription(final Describable describable) {
            this.description = Suppliers.memoize((Supplier)new Supplier<String>(){

                public String get() {
                    return describable.description();
                }
            });
        }

        @Override
        public String description() {
            return (String)this.description.get();
        }

        public String toString() {
            return this.description();
        }
    }

    private static final class FormatDescription
    implements Describable {
        private final String formattingTemplate;
        private final Object[] args;

        private FormatDescription(String formattingTemplate, Object ... args) {
            this.formattingTemplate = (String)Preconditions.checkNotNull((Object)formattingTemplate);
            this.args = (Object[])Preconditions.checkNotNull((Object)args);
        }

        @Override
        public String description() {
            return String.format(this.formattingTemplate, this.args);
        }

        public String toString() {
            return this.description();
        }
    }

    private static final class NonLazyDescription
    implements Describable {
        private final String description;

        private NonLazyDescription(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description);
        }

        @Override
        public String description() {
            return this.description;
        }

        public String toString() {
            return this.description();
        }
    }
}

