/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.guavaextensions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Functions2 {
    private Functions2() {
    }

    @Nonnull
    public static <T> Function<T, T> compound(Function<T, T> first, Function<T, T> second) {
        Preconditions.checkNotNull(first);
        Preconditions.checkNotNull(second);
        if (first == Functions.identity()) {
            return second;
        }
        return new CompoundFunction(first, second);
    }

    @Nonnull
    public static <E> Function<List<E>, List<E>> listTransformer(Function<E, E> elementTransformer) {
        if (elementTransformer == Functions.identity()) {
            return Functions.identity();
        }
        return new ListTransformer(elementTransformer);
    }

    @Nonnull
    public static <K, V> Function<Map<K, V>, Map<K, V>> mapValueTransformer(Function<V, V> valueTransformer) {
        if (valueTransformer == Functions.identity()) {
            return Functions.identity();
        }
        return new MapValueTransformer(valueTransformer);
    }

    @Nonnull
    public static <E> Function<List<E>, List<E>> unmodifiableList() {
        return new UnmodifiableListMaker();
    }

    @Nonnull
    public static <K, V> Function<Map<K, V>, Map<K, V>> unmodifiableMap() {
        return new UnmodifiableMapMaker();
    }

    @Nonnull
    public static <T> Function<T, T> repeat(Function<T, T> function, long times) {
        Preconditions.checkNotNull(function);
        Preconditions.checkArgument((times >= 0L ? 1 : 0) != 0, (String)"times (%s) must be positive", (Object[])new Object[]{times});
        return new FunctionRepeater(function, times);
    }

    public static Function<File, String> fileToString() {
        return FileToString.INSTANCE;
    }

    private static final class FileToString
    implements Function<File, String> {
        private static final Function<File, String> INSTANCE = new FileToString();

        private FileToString() {
        }

        public String apply(@Nonnull File input) {
            if (input.isDirectory()) {
                throw new IllegalArgumentException(input.getAbsolutePath() + " is a directory, not a file");
            }
            try {
                return Files.toString((File)input, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("I/O error occured while reading: " + input.getAbsolutePath(), e);
            }
        }
    }

    private static final class FunctionRepeater<T>
    implements Function<T, T> {
        private final long times;
        @Nonnull
        private final Function<T, T> function;

        private FunctionRepeater(Function<T, T> function, long times) {
            this.function = function;
            this.times = times;
        }

        public T apply(T input) {
            Object output = input;
            for (long i = 0L; i < this.times; ++i) {
                output = this.function.apply(output);
            }
            return output;
        }
    }

    private static final class UnmodifiableMapMaker<K, V>
    implements Function<Map<K, V>, Map<K, V>> {
        private UnmodifiableMapMaker() {
        }

        public Map<K, V> apply(Map<K, V> value) {
            if (value == null) {
                return null;
            }
            return Collections.unmodifiableMap(value);
        }
    }

    private static final class UnmodifiableListMaker<E>
    implements Function<List<E>, List<E>> {
        private UnmodifiableListMaker() {
        }

        public List<E> apply(List<E> value) {
            if (value == null) {
                return null;
            }
            return Collections.unmodifiableList(value);
        }
    }

    private static final class MapValueTransformer<K, V>
    implements Function<Map<K, V>, Map<K, V>> {
        private final Function<V, V> valueTransformer;

        private MapValueTransformer(Function<V, V> valueTransformer) {
            this.valueTransformer = (Function)Preconditions.checkNotNull(valueTransformer);
        }

        public Map<K, V> apply(Map<K, V> map) {
            if (map == null) {
                return null;
            }
            return ImmutableMap.copyOf((Map)Maps.transformValues(map, this.valueTransformer));
        }
    }

    private static final class ListTransformer<E>
    implements Function<List<E>, List<E>> {
        private final Function<E, E> elementTransformer;

        private ListTransformer(Function<E, E> elementTransformer) {
            this.elementTransformer = (Function)Preconditions.checkNotNull(elementTransformer);
        }

        public List<E> apply(List<E> values) {
            if (values == null) {
                return null;
            }
            return ImmutableList.copyOf((Collection)Lists.transform(values, this.elementTransformer));
        }
    }

    private static final class CompoundFunction<T>
    implements Function<T, T> {
        @Nonnull
        private final Function<T, T> first;
        @Nonnull
        private final Function<T, T> second;

        private CompoundFunction(Function<T, T> first, Function<T, T> second) {
            this.first = first;
            this.second = second;
        }

        @Nullable
        public T apply(@Nullable T value) {
            return (T)this.second.apply(this.first.apply(value));
        }
    }
}

