/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.settings;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import se.bjurr.gitchangelog.internal.settings.CustomIssue;

public class Settings {
    private static Gson gson = new Gson();
    private String fromRepo;
    private String fromRef;
    private String toRef;
    private String ignoreCommitsIfMessageMatches;
    private String jiraServer;
    private String jiraIssuePattern;
    private String githubServer;
    private String githubIssuePattern;
    private String toCommit;
    private String fromCommit;
    private String untaggedName;
    private String templatePath;
    private String readableTagName;
    private String dateFormat;
    private String noIssueName;
    private List<CustomIssue> customIssues;
    private String timeZone;

    public void setCustomIssues(List<CustomIssue> customIssues) {
        this.customIssues = customIssues;
    }

    public void setFromRef(String fromRef) {
        this.fromRef = fromRef;
    }

    public void setToRef(String toRef) {
        this.toRef = toRef;
    }

    public String getFromRef() {
        return this.fromRef;
    }

    public String getToRef() {
        return this.toRef;
    }

    public void setFromRepo(String fromRepo) {
        this.fromRepo = fromRepo;
    }

    public String getFromRepo() {
        return this.fromRepo;
    }

    public void setGithubIssuePattern(String githubIssuePattern) {
        this.githubIssuePattern = githubIssuePattern;
    }

    public void setGithubServer(String githubServer) {
        this.githubServer = githubServer;
    }

    public void setIgnoreCommitsIfMessageMatches(String ignoreCommitsIfMessageMatches) {
        this.ignoreCommitsIfMessageMatches = ignoreCommitsIfMessageMatches;
    }

    public void setJiraIssuePattern(String jiraIssuePattern) {
        this.jiraIssuePattern = jiraIssuePattern;
    }

    public void setJiraServer(String jiraServer) {
        this.jiraServer = jiraServer;
    }

    public List<CustomIssue> getCustomIssues() {
        return this.customIssues;
    }

    public Optional<String> getGithubIssuePattern() {
        return Optional.fromNullable((Object)this.githubIssuePattern);
    }

    public Optional<String> getGithubServer() {
        return Optional.fromNullable((Object)this.githubServer);
    }

    public String getIgnoreCommitsIfMessageMatches() {
        return this.ignoreCommitsIfMessageMatches;
    }

    public Optional<String> getJiraIssuePattern() {
        return Optional.fromNullable((Object)this.jiraIssuePattern);
    }

    public Optional<String> getJiraServer() {
        return Optional.fromNullable((Object)this.jiraServer);
    }

    public static Settings fromFile(URL url) {
        try {
            return (Settings)gson.fromJson(Resources.toString((URL)url, (Charset)Charsets.UTF_8), Settings.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read " + url, e);
        }
    }

    public void setFromCommit(String fromCommit) {
        this.fromCommit = fromCommit;
    }

    public void setToCommit(String toCommit) {
        this.toCommit = toCommit;
    }

    public String getFromCommit() {
        return this.fromCommit;
    }

    public String getToCommit() {
        return this.toCommit;
    }

    public String getUntaggedName() {
        return this.untaggedName;
    }

    public void setUntaggedName(String untaggedName) {
        this.untaggedName = untaggedName;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getReadableTagName() {
        return this.readableTagName;
    }

    public String getReadableTagPattern() {
        return this.readableTagName;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setNoIssueName(String noIssueName) {
        this.noIssueName = noIssueName;
    }

    public void setReadableTagName(String readableTagName) {
        this.readableTagName = readableTagName;
    }

    public String getNoIssueName() {
        return this.noIssueName;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeZone() {
        return this.timeZone;
    }
}

