/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.git;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;

public class GitRepo {
    private static final Function<RevCommit, GitCommit> TO_GITCOMMIT = new Function<RevCommit, GitCommit>(){

        public GitCommit apply(RevCommit input) {
            return new GitCommit(input.getAuthorIdent().getName(), input.getAuthorIdent().getEmailAddress(), new Date((long)input.getCommitTime() * 1000L), input.getFullMessage(), input.getId().getName().substring(0, 15));
        }
    };
    private final Repository repository;

    public GitRepo() {
        this.repository = null;
    }

    public GitRepo(File repo) {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Optional<File> gitDir = GitRepo.findClosestGitRepo(repo);
        try {
            this.repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir((File)gitDir.get())).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GitCommit> getDiff(ObjectId from, ObjectId to) {
        try (Git git = new Git(this.repository);){
            Iterable itr = git.log().addRange((AnyObjectId)from, (AnyObjectId)to).call();
            ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.transform((Iterable)itr, TO_GITCOMMIT));
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("References:\n" + Joiner.on((String)"\n").join(this.repository.getAllRefs().keySet()), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GitTag> getTags() {
        try (Git git = new Git(this.repository);){
            ArrayList refs = Lists.newArrayList();
            for (Ref ref : git.tagList().call()) {
                LogCommand log = git.log();
                Ref peeledRef = this.repository.peel(ref);
                if (peeledRef.getPeeledObjectId() != null) {
                    log.add((AnyObjectId)peeledRef.getPeeledObjectId());
                } else {
                    log.add((AnyObjectId)ref.getObjectId());
                }
                Iterable itr = log.call();
                List commits = Lists.transform((List)Lists.newArrayList((Iterable)itr), TO_GITCOMMIT);
                refs.add(new GitTag(ref.getName(), commits));
            }
            ArrayList arrayList = refs;
            return arrayList;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public ObjectId getRef(String fromRef) {
        try {
            return ((Ref)this.repository.getAllRefs().get(fromRef)).getObjectId();
        }
        catch (Exception e) {
            throw new RuntimeException(fromRef + " not found in:\n" + Joiner.on((String)"\n").join(this.repository.getAllRefs().values()), e);
        }
    }

    public ObjectId getCommit(String fromCommit) {
        if (fromCommit.startsWith("0000000000000000000000000000000000000000")) {
            return this.firstCommit();
        }
        return ObjectId.fromString((String)fromCommit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectId firstCommit() {
        try (RevWalk walk = new RevWalk(this.repository);){
            RevCommit root = walk.parseCommit((AnyObjectId)this.repository.resolve("HEAD"));
            walk.sort(RevSort.REVERSE);
            walk.markStart(root);
            RevCommit revCommit = walk.next();
            return revCommit;
        }
        catch (Exception e) {
            throw new RuntimeException("First commit not found!", e);
        }
    }

    private static Optional<File> findClosestGitRepo(File file) {
        File candidate = new File(file.getAbsolutePath() + "/.git");
        if (candidate.exists()) {
            return Optional.of((Object)candidate);
        }
        if (file.getParent() == null) {
            return Optional.absent();
        }
        return GitRepo.findClosestGitRepo(file.getParentFile());
    }
}

