/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import se.bjurr.gitchangelog.internal.git.GitRepo;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;

public class FakeGitRepo
extends GitRepo {
    public static long DAY_ZERO = 0L;
    public static long TIME_DAY = 86400000L;
    private final List<GitCommit> commits = Lists.newArrayList();
    private final List<GitTag> tags = Lists.newArrayList();

    public FakeGitRepo() {
        this.commits.add(new GitCommit("authorName", "authorEmailAddress", new Date(DAY_ZERO), "First commit!", "0000000000000000000000000000000000000000"));
    }

    public FakeGitRepo withCommit(GitCommit gitCommit) {
        this.commits.add(gitCommit);
        return this;
    }

    public FakeGitRepo withTag(GitTag gitTag) {
        this.tags.add(gitTag);
        return this;
    }

    public ObjectId getCommit(String fromCommit) {
        ImmutableMap commitsMap = Maps.uniqueIndex(this.commits, (Function)new Function<GitCommit, String>(){

            public String apply(GitCommit input) {
                return input.getHash();
            }
        });
        return ObjectId.fromString((String)((GitCommit)Preconditions.checkNotNull(commitsMap.get(fromCommit), (Object)("Not found: " + fromCommit + " in:\n" + Joiner.on((String)"\n").join(commitsMap.keySet())))).getHash());
    }

    public ObjectId getRef(String fromRef) {
        if (fromRef.equals("refs/heads/master")) {
            return ObjectId.fromString((String)this.commits.get(this.commits.size() - 1).getHash());
        }
        ImmutableMap tagsMap = Maps.uniqueIndex(this.tags, (Function)new Function<GitTag, String>(){

            public String apply(GitTag input) {
                return input.getGitCommit().getHash();
            }
        });
        return ObjectId.fromString((String)((GitTag)Preconditions.checkNotNull(tagsMap.get(fromRef), (Object)("Not found: " + fromRef + " in:\n" + Joiner.on((String)"\n").join(tagsMap.keySet())))).getGitCommit().getHash());
    }

    public List<GitTag> getTags() {
        return this.tags;
    }

    public List<GitCommit> getDiff(ObjectId from, ObjectId to) {
        ArrayList toReturn = Lists.newArrayList();
        boolean included = true;
        for (GitCommit gitCommit : this.commits) {
            if (gitCommit.getHash().equals(from.getName())) {
                included = true;
            }
            if (included) {
                toReturn.add(gitCommit);
            }
            if (!gitCommit.getHash().equals(to.getName())) continue;
            break;
        }
        return toReturn;
    }
}

