package se.bjurr.gitchangelog.api.model;

import static com.google.common.base.Preconditions.checkArgument;

import java.util.List;

import se.bjurr.gitchangelog.api.model.interfaces.IAuthors;
import se.bjurr.gitchangelog.api.model.interfaces.ICommits;
import se.bjurr.gitchangelog.api.model.interfaces.IIssues;

public class Tag implements ICommits, IAuthors, IIssues {
 private final List<Commit> commits;
 private final List<Author> authors;
 private final List<Issue> issues;
 private final String name;

 public Tag(String name, List<Commit> commits, List<Author> authors, List<Issue> issues) {
  checkArgument(!commits.isEmpty(), "commits is empty!");
  checkArgument(!authors.isEmpty(), "authors is empty!");
  this.commits = commits;
  this.authors = authors;
  this.issues = issues;
  this.name = name;
 }

 @Override
 public List<Issue> getIssues() {
  return issues;
 }

 @Override
 public List<Author> getAuthors() {
  return authors;
 }

 public String getName() {
  return name;
 }

 public Commit getCommit() {
  return commits.get(0);
 }

 @Override
 public List<Commit> getCommits() {
  return commits;
 }
}
