/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.plugin;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlModifier {
    private final File file;

    public XmlModifier(File file) {
        this.file = file;
    }

    public void setVersion(String value) throws Exception {
        Document document = this.readDocument();
        Node projectNode = this.getNode(document.getChildNodes(), "project");
        Node versionNode = this.getNode(projectNode.getChildNodes(), "version");
        versionNode.setTextContent(value);
        this.saveDocument(document);
    }

    private Document readDocument() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.parse(this.file);
        return document;
    }

    private void saveDocument(Node document) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(this.file);
        transformer.transform(source, result);
    }

    private Node getNode(NodeList nodes, String tagName) {
        Node found = null;
        for (int tagIndex = 0; tagIndex < nodes.getLength(); ++tagIndex) {
            Node tag = nodes.item(tagIndex);
            if (!tag.getNodeName().equals(tagName)) continue;
            if (found != null) {
                throw new RuntimeException("Found multiple " + tagName + " in " + nodes);
            }
            found = tag;
        }
        if (found == null) {
            throw new RuntimeException("Cannot find " + tagName + " in " + nodes);
        }
        return found;
    }
}

