/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.settings;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;

public class Settings
implements Serializable {
    private static final long serialVersionUID = 4565886594381385244L;
    private static Gson gson = new Gson();
    private String fromRepo;
    private String fromRef;
    private String toRef;
    private String fromCommit;
    private String toCommit;
    private String ignoreTagsIfNameMatches;
    private String ignoreCommitsIfMessageMatches;
    private Date ignoreCommitsIfOlderThan;
    private String untaggedName;
    private String templatePath;
    private String readableTagName;
    private String dateFormat;
    private String noIssueName;
    private String timeZone;
    private boolean removeIssueFromMessage;
    private String jiraServer;
    private String jiraIssuePattern;
    private String jiraUsername;
    private String jiraPassword;
    private String jiraToken;
    private String gitHubApi;
    private String gitHubToken;
    private String gitHubIssuePattern;
    private List<SettingsIssue> customIssues;
    private Map<String, Object> extendedVariables;
    private boolean ignoreCommitsWithoutIssue;
    private String gitLabServer;
    private String gitLabToken;
    private String gitLabIssuePattern;
    private String gitLabProjectName;

    public void setCustomIssues(List<SettingsIssue> customIssues) {
        this.customIssues = customIssues;
    }

    public void setFromRef(String fromRef) {
        this.fromRef = fromRef == null || fromRef.trim().isEmpty() ? null : fromRef.trim();
    }

    public void setToRef(String toRef) {
        this.toRef = toRef == null || toRef.trim().isEmpty() ? null : toRef.trim();
    }

    public Optional<String> getFromRef() {
        return Optional.fromNullable((Object)this.fromRef);
    }

    public Optional<String> getToRef() {
        return Optional.fromNullable((Object)this.toRef);
    }

    public void setFromRepo(String fromRepo) {
        this.fromRepo = fromRepo;
    }

    public String getFromRepo() {
        return (String)Optional.fromNullable((Object)this.fromRepo).or((Object)".");
    }

    public void setIgnoreCommitsIfMessageMatches(String ignoreCommitsIfMessageMatches) {
        this.ignoreCommitsIfMessageMatches = ignoreCommitsIfMessageMatches;
    }

    public void setIgnoreTagsIfNameMatches(String ignoreTagsIfNameMatches) {
        this.ignoreTagsIfNameMatches = ignoreTagsIfNameMatches;
    }

    public void setIgnoreCommitsIfOlderThan(Date ignoreCommitsIfOlderThan) {
        this.ignoreCommitsIfOlderThan = ignoreCommitsIfOlderThan != null ? new Date(ignoreCommitsIfOlderThan.getTime()) : null;
    }

    public void setJiraIssuePattern(String jiraIssuePattern) {
        this.jiraIssuePattern = jiraIssuePattern;
    }

    public void setJiraServer(String jiraServer) {
        this.jiraServer = jiraServer;
    }

    public void addCustomIssue(SettingsIssue customIssue) {
        if (this.customIssues == null) {
            this.customIssues = Lists.newArrayList();
        }
        this.customIssues.add(customIssue);
    }

    public List<SettingsIssue> getCustomIssues() {
        if (this.customIssues == null) {
            return new ArrayList<SettingsIssue>();
        }
        return this.customIssues;
    }

    public String getIgnoreCommitsIfMessageMatches() {
        return (String)Optional.fromNullable((Object)this.ignoreCommitsIfMessageMatches).or((Object)"^\\[maven-release-plugin\\].*|^\\[Gradle Release Plugin\\].*|^Merge.*");
    }

    public Optional<Date> getIgnoreCommitsIfOlderThan() {
        return Optional.fromNullable((Object)this.ignoreCommitsIfOlderThan);
    }

    public String getJiraIssuePattern() {
        return (String)Optional.fromNullable((Object)this.jiraIssuePattern).or((Object)"\\b[a-zA-Z]([a-zA-Z]+)-([0-9]+)\\b");
    }

    public Optional<String> getJiraServer() {
        return Optional.fromNullable((Object)this.jiraServer);
    }

    public static Settings fromFile(URL url) {
        try {
            return (Settings)gson.fromJson(Resources.toString((URL)url, (Charset)Charsets.UTF_8), Settings.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read " + url, e);
        }
    }

    public void setFromCommit(String fromCommit) {
        this.fromCommit = fromCommit;
    }

    public void setToCommit(String toCommit) {
        this.toCommit = toCommit;
    }

    public Optional<String> getFromCommit() {
        return Optional.fromNullable((Object)Strings.emptyToNull((String)this.fromCommit));
    }

    public Optional<String> getToCommit() {
        return Optional.fromNullable((Object)Strings.emptyToNull((String)this.toCommit));
    }

    public String getUntaggedName() {
        return (String)Optional.fromNullable((Object)this.untaggedName).or((Object)"Unreleased");
    }

    public Optional<String> getIgnoreTagsIfNameMatches() {
        return Optional.fromNullable((Object)this.ignoreTagsIfNameMatches);
    }

    public void setUntaggedName(String untaggedName) {
        this.untaggedName = untaggedName;
    }

    public String getTemplatePath() {
        return (String)Optional.fromNullable((Object)this.templatePath).or((Object)"changelog.mustache");
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getReadableTagName() {
        return (String)Optional.fromNullable((Object)this.readableTagName).or((Object)"/([^/]+?)$");
    }

    public String getDateFormat() {
        return (String)Optional.fromNullable((Object)this.dateFormat).or((Object)"YYYY-MM-dd HH:mm:ss");
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setNoIssueName(String noIssueName) {
        this.noIssueName = noIssueName;
    }

    public void setReadableTagName(String readableTagName) {
        this.readableTagName = readableTagName;
    }

    public String getNoIssueName() {
        return (String)Optional.fromNullable((Object)this.noIssueName).or((Object)"No issue");
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeZone() {
        return (String)Optional.fromNullable((Object)this.timeZone).or((Object)"UTC");
    }

    public static Settings defaultSettings() {
        URL resource = null;
        try {
            resource = Resources.getResource((String)"git-changelog-settings.json");
            return Settings.fromFile(resource.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot find default config in " + resource, e);
        }
    }

    public void setRemoveIssueFromMessage(boolean removeIssueFromMessage) {
        this.removeIssueFromMessage = removeIssueFromMessage;
    }

    public Boolean removeIssueFromMessage() {
        return (Boolean)Optional.fromNullable((Object)this.removeIssueFromMessage).or((Object)true);
    }

    public Optional<String> getGitHubApi() {
        return Optional.fromNullable((Object)this.gitHubApi);
    }

    public Optional<String> getGitHubToken() {
        return Optional.fromNullable((Object)this.gitHubToken);
    }

    public void setGitHubApi(String gitHubApi) {
        this.gitHubApi = gitHubApi;
    }

    public void setGitHubToken(String gitHubToken) {
        this.gitHubToken = gitHubToken;
    }

    public void setGitHubIssuePattern(String gitHubIssuePattern) {
        this.gitHubIssuePattern = gitHubIssuePattern;
    }

    public String getGitHubIssuePattern() {
        return (String)Optional.fromNullable((Object)this.gitHubIssuePattern).or((Object)"#([0-9]+)");
    }

    public Optional<String> getJiraUsername() {
        return Optional.fromNullable((Object)this.jiraUsername);
    }

    public void setJiraPassword(String jiraPassword) {
        this.jiraPassword = jiraPassword;
    }

    public void setJiraToken(String jiraToken) {
        this.jiraToken = jiraToken;
    }

    public void setJiraUsername(String jiraUsername) {
        this.jiraUsername = jiraUsername;
    }

    public Optional<String> getJiraPassword() {
        return Optional.fromNullable((Object)this.jiraPassword);
    }

    public Optional<String> getJiraToken() {
        return Optional.fromNullable((Object)this.jiraToken);
    }

    public void setExtendedVariables(Map<String, Object> extendedVariables) {
        this.extendedVariables = extendedVariables;
    }

    public Map<String, Object> getExtendedVariables() {
        return this.extendedVariables;
    }

    public void setIgnoreCommitsWithoutIssue(boolean ignoreCommitsWithoutIssue) {
        this.ignoreCommitsWithoutIssue = ignoreCommitsWithoutIssue;
    }

    public boolean ignoreCommitsWithoutIssue() {
        return this.ignoreCommitsWithoutIssue;
    }

    public void setGitLabIssuePattern(String gitLabIssuePattern) {
        this.gitLabIssuePattern = gitLabIssuePattern;
    }

    public void setGitLabProjectName(String gitLabProjectName) {
        this.gitLabProjectName = gitLabProjectName;
    }

    public void setGitLabServer(String gitLabServer) {
        this.gitLabServer = gitLabServer;
    }

    public void setGitLabToken(String gitLabToken) {
        this.gitLabToken = gitLabToken;
    }

    public Optional<String> getGitLabServer() {
        return Optional.fromNullable((Object)this.gitLabServer);
    }

    public Optional<String> getGitLabToken() {
        return Optional.fromNullable((Object)this.gitLabToken);
    }

    public String getGitLabIssuePattern() {
        return (String)Optional.fromNullable((Object)this.gitLabIssuePattern).or((Object)"#([0-9]+)");
    }

    public Optional<String> getGitLabProjectName() {
        return Optional.fromNullable((Object)this.gitLabProjectName);
    }
}

