/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.settings;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import se.bjurr.gitchangelog.internal.settings.Settings;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;
import se.bjurr.gitchangelog.internal.settings.SettingsIssueType;

public class IssuesUtil {
    private final Settings settings;

    public IssuesUtil(Settings settings) {
        this.settings = settings;
    }

    public List<SettingsIssue> getIssues() {
        ArrayList issues = Lists.newArrayList(this.settings.getCustomIssues());
        this.addJira(issues);
        this.addGitHub(issues);
        this.addGitLab(issues);
        return issues;
    }

    private void addGitHub(List<SettingsIssue> issues) {
        if (!Strings.isNullOrEmpty((String)this.settings.getGitHubIssuePattern()) && this.settings.getGitHubApi().isPresent()) {
            issues.add(new SettingsIssue(SettingsIssueType.GITHUB, "GitHub", this.settings.getGitHubIssuePattern(), null, null));
        }
    }

    private void addGitLab(List<SettingsIssue> issues) {
        if (!Strings.isNullOrEmpty((String)this.settings.getGitLabIssuePattern()) && this.settings.getGitLabServer().isPresent()) {
            issues.add(new SettingsIssue(SettingsIssueType.GITLAB, "GitLab", this.settings.getGitLabIssuePattern(), null, null));
        }
    }

    private void addJira(List<SettingsIssue> issues) {
        if (!Strings.isNullOrEmpty((String)this.settings.getJiraIssuePattern())) {
            if (this.settings.getJiraServer().isPresent()) {
                issues.add(new SettingsIssue(SettingsIssueType.JIRA, "Jira", this.settings.getJiraIssuePattern(), (String)this.settings.getJiraServer().or((Object)"") + "/browse/${PATTERN_GROUP}", null));
            } else {
                issues.add(new SettingsIssue(SettingsIssueType.JIRA, "Jira", this.settings.getJiraIssuePattern(), (String)this.settings.getJiraServer().orNull(), null));
            }
        }
    }
}

