/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.bjurr.gitchangelog.api.model.Author;
import se.bjurr.gitchangelog.api.model.Commit;
import se.bjurr.gitchangelog.api.model.Issue;
import se.bjurr.gitchangelog.api.model.IssueType;
import se.bjurr.gitchangelog.api.model.Tag;
import se.bjurr.gitchangelog.internal.common.GitPredicates;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;
import se.bjurr.gitchangelog.internal.settings.IssuesUtil;
import se.bjurr.gitchangelog.internal.settings.Settings;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;

public class Transformer {
    private final Settings settings;

    public Transformer(Settings settings) {
        this.settings = settings;
    }

    public List<Author> toAuthors(List<GitCommit> gitCommits) {
        ImmutableListMultimap commitsPerAuthor = Multimaps.index(gitCommits, (Function)new Function<GitCommit, String>(){

            public String apply(GitCommit input) {
                return input.getAuthorEmailAddress() + "-" + input.getAuthorName();
            }
        });
        Iterable authorsWithCommits = Iterables.filter((Iterable)commitsPerAuthor.keySet(), (Predicate)new Predicate<String>((Multimap)commitsPerAuthor){
            final /* synthetic */ Multimap val$commitsPerAuthor;
            {
                this.val$commitsPerAuthor = multimap;
            }

            public boolean apply(String input) {
                return Transformer.this.toCommits(this.val$commitsPerAuthor.get((Object)input)).size() > 0;
            }
        });
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)authorsWithCommits, (Function)new Function<String, Author>((Multimap)commitsPerAuthor){
            final /* synthetic */ Multimap val$commitsPerAuthor;
            {
                this.val$commitsPerAuthor = multimap;
            }

            public Author apply(String input) {
                ArrayList gitCommitsOfSameAuthor = Lists.newArrayList((Iterable)this.val$commitsPerAuthor.get((Object)input));
                List<Commit> commitsOfSameAuthor = Transformer.this.toCommits(gitCommitsOfSameAuthor);
                return new Author(commitsOfSameAuthor.get(0).getAuthorName(), commitsOfSameAuthor.get(0).getAuthorEmailAddress(), commitsOfSameAuthor);
            }
        }));
    }

    public List<Commit> toCommits(Collection<GitCommit> from) {
        Iterable filteredCommits = Iterables.filter(from, GitPredicates.ignoreCommits(this.settings));
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)filteredCommits, (Function)new Function<GitCommit, Commit>(){

            public Commit apply(GitCommit c) {
                return Transformer.this.toCommit(c);
            }
        }));
    }

    public List<Issue> toIssues(List<ParsedIssue> issues) {
        Iterable<ParsedIssue> issuesWithCommits = this.filterWithCommits(issues);
        return Lists.newArrayList((Iterable)Iterables.transform(issuesWithCommits, this.parsedIssueToIssue()));
    }

    public List<IssueType> toIssueTypes(List<ParsedIssue> issues) {
        TreeMap issuesPerName = Maps.newTreeMap();
        for (ParsedIssue parsedIssue : this.filterWithCommits(issues)) {
            if (!issuesPerName.containsKey(parsedIssue.getName())) {
                issuesPerName.put(parsedIssue.getName(), new ArrayList());
            }
            Issue transformedIssues = (Issue)this.parsedIssueToIssue().apply((Object)parsedIssue);
            ((List)issuesPerName.get(parsedIssue.getName())).add(transformedIssues);
        }
        ArrayList issueTypes = Lists.newArrayList();
        for (String name : issuesPerName.keySet()) {
            issueTypes.add(new IssueType((List)issuesPerName.get(name), name));
        }
        return issueTypes;
    }

    public List<Tag> toTags(List<GitTag> gitTags, final List<ParsedIssue> allParsedIssues) {
        Iterable tags = Lists.transform(gitTags, (Function)new Function<GitTag, Tag>(){

            public Tag apply(GitTag input) {
                List<GitCommit> gitCommits = input.getGitCommits();
                List<ParsedIssue> parsedIssues = this.reduceParsedIssuesToOnlyGitCommits(allParsedIssues, gitCommits);
                List<Commit> commits = Transformer.this.toCommits(gitCommits);
                List<Author> authors = Transformer.this.toAuthors(gitCommits);
                List<Issue> issues = Transformer.this.toIssues(parsedIssues);
                List<IssueType> issueTypes = Transformer.this.toIssueTypes(parsedIssues);
                return new Tag(Transformer.this.toReadableTagName(input.getName()), (String)input.findAnnotation().orNull(), commits, authors, issues, issueTypes, input.getTagTime() != null ? Transformer.this.format(input.getTagTime()) : "", input.getTagTime() != null ? input.getTagTime().getTime() : -1L);
            }

            private List<ParsedIssue> reduceParsedIssuesToOnlyGitCommits(List<ParsedIssue> allParsedIssues2, List<GitCommit> gitCommits) {
                ArrayList parsedIssues = Lists.newArrayList();
                for (ParsedIssue candidate : allParsedIssues2) {
                    ArrayList candidateCommits = Lists.newArrayList((Iterable)Iterables.filter(candidate.getGitCommits(), (Predicate)Predicates.in(gitCommits)));
                    if (candidateCommits.isEmpty()) continue;
                    ParsedIssue parsedIssue = new ParsedIssue(candidate.getSettingsIssueType(), candidate.getName(), candidate.getIssue(), candidate.getDescription(), candidate.getLink(), (String)candidate.getTitle().orNull(), candidate.getIssueType(), candidate.getLinkedIssues(), candidate.getLabels());
                    parsedIssue.addCommits(candidateCommits);
                    parsedIssues.add(parsedIssue);
                }
                return parsedIssues;
            }
        });
        tags = Iterables.filter((Iterable)tags, (Predicate)new Predicate<Tag>(){

            public boolean apply(Tag input) {
                return !input.getAuthors().isEmpty() && !input.getCommits().isEmpty();
            }
        });
        return Lists.newArrayList((Iterable)tags);
    }

    private Iterable<ParsedIssue> filterWithCommits(List<ParsedIssue> issues) {
        Iterable issuesWithCommits = Iterables.filter(issues, (Predicate)new Predicate<ParsedIssue>(){

            public boolean apply(ParsedIssue input) {
                return !Transformer.this.toCommits(input.getGitCommits()).isEmpty();
            }
        });
        return issuesWithCommits;
    }

    private String format(Date commitTime) {
        SimpleDateFormat df = new SimpleDateFormat(this.settings.getDateFormat());
        df.setTimeZone(TimeZone.getTimeZone(this.settings.getTimeZone()));
        return df.format(commitTime);
    }

    private Function<ParsedIssue, Issue> parsedIssueToIssue() {
        return new Function<ParsedIssue, Issue>(){

            public Issue apply(ParsedIssue input) {
                List<GitCommit> gitCommits = input.getGitCommits();
                return new Issue(Transformer.this.toCommits(gitCommits), Transformer.this.toAuthors(gitCommits), input.getName(), (String)input.getTitle().or((Object)""), input.getIssue(), input.getSettingsIssueType(), input.getDescription(), input.getLink(), input.getIssueType(), input.getLinkedIssues(), input.getLabels());
            }
        };
    }

    private String removeIssuesFromString(boolean removeIssueFromMessage, List<SettingsIssue> issues, String string) {
        if (removeIssueFromMessage) {
            for (SettingsIssue issue : issues) {
                string = string.replaceAll(issue.getPattern(), "");
            }
        }
        return string;
    }

    private Commit toCommit(GitCommit gitCommit) {
        return new Commit(gitCommit.getAuthorName(), gitCommit.getAuthorEmailAddress(), this.format(gitCommit.getCommitTime()), gitCommit.getCommitTime().getTime(), this.toMessage(this.settings.removeIssueFromMessage(), new IssuesUtil(this.settings).getIssues(), gitCommit.getMessage()), gitCommit.getHash(), gitCommit.isMerge());
    }

    private String toReadableTagName(String input) {
        Matcher matcher = Pattern.compile(this.settings.getReadableTagName()).matcher(input);
        if (matcher.find()) {
            if (matcher.groupCount() == 0) {
                throw new RuntimeException("Pattern: \"" + this.settings.getReadableTagName() + "\" did not match any group in: \"" + input + "\"");
            }
            return matcher.group(1);
        }
        return input;
    }

    @VisibleForTesting
    String toMessage(boolean removeIssueFromMessage, List<SettingsIssue> issues, String message) {
        return this.removeIssuesFromString(removeIssueFromMessage, issues, message);
    }
}

