/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.issues;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubHelper;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubIssue;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubLabel;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubServiceFactory;
import se.bjurr.gitchangelog.internal.integrations.gitlab.GitLabClient;
import se.bjurr.gitchangelog.internal.integrations.gitlab.GitLabIssue;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraClient;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraClientFactory;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraIssue;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;
import se.bjurr.gitchangelog.internal.settings.IssuesUtil;
import se.bjurr.gitchangelog.internal.settings.Settings;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;
import se.bjurr.gitchangelog.internal.settings.SettingsIssueType;

public class IssueParser {
    private static final Logger LOG = LoggerFactory.getLogger(IssueParser.class);
    private final List<GitCommit> commits;
    private final Settings settings;

    public IssueParser(Settings settings, List<GitCommit> commits) {
        this.settings = settings;
        this.commits = commits;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public List<GitCommit> getCommits() {
        return this.commits;
    }

    public List<ParsedIssue> parseForIssues(boolean useIntegrationIfConfigured) {
        HashMap parsedIssuePerIssue = Maps.newHashMap();
        GitHubHelper gitHubHelper = useIntegrationIfConfigured ? this.createGitHubClient() : null;
        JiraClient jiraClient = useIntegrationIfConfigured ? this.createJiraClient() : null;
        GitLabClient gitLabClient = useIntegrationIfConfigured ? this.createGitLabClient() : null;
        List<SettingsIssue> patterns = new IssuesUtil(this.settings).getIssues();
        for (GitCommit gitCommit : this.commits) {
            boolean commitMappedToAtLeastOneIssue = false;
            for (SettingsIssue issuePattern : patterns) {
                Matcher issueMatcher = Pattern.compile(issuePattern.getPattern()).matcher(gitCommit.getMessage());
                while (issueMatcher.find()) {
                    String matchedIssue = issueMatcher.group();
                    if (matchedIssue.isEmpty()) continue;
                    if (!parsedIssuePerIssue.containsKey(matchedIssue)) {
                        ParsedIssue parsedIssue = null;
                        if (issuePattern.getType() == SettingsIssueType.GITHUB) {
                            parsedIssue = this.createParsedIssue(gitHubHelper, issuePattern, matchedIssue);
                        } else if (issuePattern.getType() == SettingsIssueType.GITLAB) {
                            String projectName = (String)this.settings.getGitLabProjectName().get();
                            parsedIssue = this.createParsedIssue(gitLabClient, projectName, issuePattern, matchedIssue);
                        } else {
                            parsedIssue = issuePattern.getType() == SettingsIssueType.JIRA ? this.createParsedIssue(jiraClient, issuePattern, matchedIssue) : this.createParsedIssue(issuePattern, issueMatcher, matchedIssue);
                        }
                        parsedIssuePerIssue.put(matchedIssue, parsedIssue);
                    }
                    if (!((ParsedIssue)parsedIssuePerIssue.get(matchedIssue)).getGitCommits().contains(gitCommit)) {
                        ((ParsedIssue)parsedIssuePerIssue.get(matchedIssue)).getGitCommits().add(gitCommit);
                    }
                    commitMappedToAtLeastOneIssue = true;
                }
            }
            if (commitMappedToAtLeastOneIssue || this.settings.ignoreCommitsWithoutIssue()) continue;
            String issue = null;
            String link = null;
            String title = null;
            String issueType = null;
            List<String> linkedIssues = null;
            List<String> labels = null;
            ParsedIssue noIssue = new ParsedIssue(SettingsIssueType.NOISSUE, this.settings.getNoIssueName(), issue, "", link, title, issueType, linkedIssues, labels);
            if (!parsedIssuePerIssue.containsKey(noIssue.getName())) {
                parsedIssuePerIssue.put(noIssue.getName(), noIssue);
            }
            ((ParsedIssue)parsedIssuePerIssue.get(noIssue.getName())).addCommit(gitCommit);
        }
        return Ordering.usingToString().sortedCopy(parsedIssuePerIssue.values());
    }

    private ParsedIssue createParsedIssue(GitLabClient gitLabClient, String projectName, SettingsIssue issuePattern, String matchedIssueString) {
        String link = "";
        String title = "";
        ArrayList<String> linkedIssues = new ArrayList<String>();
        List<String> labels = new ArrayList<String>();
        if (matchedIssueString.startsWith("#")) {
            matchedIssueString = matchedIssueString.substring(1);
        }
        Integer matchedIssue = Integer.parseInt(matchedIssueString);
        try {
            if (gitLabClient != null && gitLabClient.getIssue(projectName, matchedIssue).isPresent()) {
                GitLabIssue gitLabIssue = (GitLabIssue)gitLabClient.getIssue(projectName, matchedIssue).get();
                link = gitLabIssue.getLink();
                title = gitLabIssue.getTitle();
                labels = gitLabIssue.getLabels();
            }
        }
        catch (GitChangelogIntegrationException e) {
            LOG.error(matchedIssueString, (Throwable)e);
        }
        String issueType = null;
        return new ParsedIssue(SettingsIssueType.GITLAB, issuePattern.getName(), matchedIssueString, "", link, title, issueType, linkedIssues, labels);
    }

    private GitLabClient createGitLabClient() {
        GitLabClient client = null;
        if (this.settings.getGitLabServer().isPresent()) {
            String server = (String)this.settings.getGitLabServer().get();
            String token = (String)this.settings.getGitLabToken().orNull();
            client = new GitLabClient(server, token);
        }
        return client;
    }

    private JiraClient createJiraClient() {
        JiraClient jiraClient = null;
        if (this.settings.getJiraServer().isPresent()) {
            jiraClient = JiraClientFactory.createJiraClient((String)this.settings.getJiraServer().get());
            if (this.settings.getJiraUsername().isPresent()) {
                jiraClient.withBasicCredentials((String)this.settings.getJiraUsername().get(), (String)this.settings.getJiraPassword().get());
            } else if (this.settings.getJiraToken().isPresent()) {
                jiraClient.withTokenCredentials((String)this.settings.getJiraToken().get());
            }
        }
        return jiraClient;
    }

    private GitHubHelper createGitHubClient() {
        GitHubHelper gitHubHelper = null;
        if (this.settings.getGitHubApi().isPresent()) {
            gitHubHelper = new GitHubHelper(GitHubServiceFactory.getGitHubService((String)this.settings.getGitHubApi().get(), this.settings.getGitHubToken()));
        }
        return gitHubHelper;
    }

    private ParsedIssue createParsedIssue(SettingsIssue issuePattern, Matcher issueMatcher, String matchedIssue) {
        String link = this.render((String)issuePattern.getLink().or((Object)""), issueMatcher, matchedIssue);
        String title = this.render((String)issuePattern.getTitle().or((Object)""), issueMatcher, matchedIssue);
        String issueType = null;
        List<String> linkedIssues = null;
        List<String> labels = null;
        return new ParsedIssue(SettingsIssueType.CUSTOM, issuePattern.getName(), matchedIssue, "", link, title, issueType, linkedIssues, labels);
    }

    private ParsedIssue createParsedIssue(JiraClient jiraClient, SettingsIssue issuePattern, String matchedIssue) {
        String link = "";
        String title = "";
        String desc = "";
        String issueType = null;
        List<String> linkedIssues = null;
        List<String> labels = null;
        try {
            if (jiraClient != null && jiraClient.getIssue(matchedIssue).isPresent()) {
                JiraIssue jiraIssue = (JiraIssue)jiraClient.getIssue(matchedIssue).get();
                link = jiraIssue.getLink();
                title = jiraIssue.getTitle();
                issueType = jiraIssue.getIssueType();
                linkedIssues = jiraIssue.getLinkedIssues();
                labels = jiraIssue.getLabels();
                desc = jiraIssue.getDescription();
            }
        }
        catch (GitChangelogIntegrationException e) {
            LOG.error(matchedIssue, (Throwable)e);
        }
        return new ParsedIssue(SettingsIssueType.JIRA, issuePattern.getName(), matchedIssue, desc, link, title, issueType, linkedIssues, labels);
    }

    private ParsedIssue createParsedIssue(GitHubHelper gitHubHelper, SettingsIssue issuePattern, String matchedIssue) {
        String link = "";
        String title = "";
        ArrayList linkedIssues = Lists.newArrayList();
        ArrayList labels = Lists.newArrayList();
        try {
            Optional<GitHubIssue> issues;
            if (gitHubHelper != null && (issues = gitHubHelper.getIssueFromAll(matchedIssue)).isPresent()) {
                GitHubIssue gitHubIssue = (GitHubIssue)issues.get();
                link = gitHubIssue.getLink();
                title = gitHubIssue.getTitle();
                for (GitHubLabel label : gitHubIssue.getLabels()) {
                    labels.add(label.getName());
                }
            }
        }
        catch (GitChangelogIntegrationException e) {
            LOG.error(matchedIssue, (Throwable)e);
        }
        String issueType = null;
        return new ParsedIssue(SettingsIssueType.GITHUB, issuePattern.getName(), matchedIssue, "", link, title, issueType, linkedIssues, labels);
    }

    private String render(String string, Matcher matcher, String matched) {
        string = string.replaceAll("\\$\\{PATTERN_GROUP\\}", matched);
        for (int i = 0; i <= matcher.groupCount(); ++i) {
            string = string.replaceAll("\\$\\{PATTERN_GROUP_" + i + "\\}", this.firstNonNull(matcher.group(i), ""));
        }
        return string;
    }

    private String firstNonNull(String a, String b) {
        if (a == null) {
            return b;
        }
        return a;
    }
}

