/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;

public class RestClient {
    private static Logger logger = LoggerFactory.getLogger(RestClient.class);
    private static RestClient mockedRestClient;
    private final LoadingCache<String, Optional<String>> urlCache;
    private String basicAuthString;

    public RestClient(long duration, TimeUnit cacheExpireAfterAccess) {
        this.urlCache = CacheBuilder.newBuilder().expireAfterAccess(duration, cacheExpireAfterAccess).build((CacheLoader)new CacheLoader<String, Optional<String>>(){

            public Optional<String> load(String url) throws Exception {
                return RestClient.this.doGet(url);
            }
        });
    }

    public RestClient withBasicAuthCredentials(String username, String password) {
        try {
            this.basicAuthString = Base64.getEncoder().encodeToString((username + ":" + password).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public RestClient withTokenAuthCredentials(String token) {
        this.basicAuthString = token;
        return this;
    }

    public Optional<String> get(String url) throws GitChangelogIntegrationException {
        try {
            return (Optional)this.urlCache.get((Object)url);
        }
        catch (Exception e) {
            throw new GitChangelogIntegrationException("Problems invoking " + url, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> doGet(String urlParam) {
        String response = null;
        HttpURLConnection conn = null;
        try {
            logger.info("GET:\n" + urlParam);
            URL url = new URL(urlParam);
            conn = this.openConnection(url);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            if (this.basicAuthString != null) {
                conn.setRequestProperty("Authorization", "Basic " + this.basicAuthString);
            }
            Optional optional = Optional.of((Object)this.getResponse(conn));
            return optional;
        }
        catch (Exception e) {
            logger.error("Got:\n" + response, (Throwable)e);
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @VisibleForTesting
    protected HttpURLConnection openConnection(URL url) throws Exception {
        if (mockedRestClient == null) {
            return (HttpURLConnection)url.openConnection();
        }
        return mockedRestClient.openConnection(url);
    }

    @VisibleForTesting
    protected String getResponse(HttpURLConnection conn) throws Exception {
        if (mockedRestClient == null) {
            return new String(ByteStreams.toByteArray((InputStream)conn.getInputStream()), "UTF-8");
        }
        return mockedRestClient.getResponse(conn);
    }

    public static void mock(RestClient mock) {
        mockedRestClient = mock;
    }
}

