/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.mediawiki;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minidev.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.rest.RestClient;

public class MediaWikiClient
extends RestClient {
    private static final String DEFAULT_ANONYMOUS_EDIT_TOKEN = "+\\";
    private static Logger logger = LoggerFactory.getLogger(MediaWikiClient.class);
    private String username;
    private String password;
    private final String url;
    private final String title;
    private final String text;

    public MediaWikiClient(String url, String title, String text) {
        super(0L, TimeUnit.MINUTES);
        this.url = url;
        this.title = title;
        this.text = text;
    }

    public MediaWikiClient withUser(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public void createMediaWikiPage() throws GitChangelogIntegrationException {
        Preconditions.checkNotNull((Object)this.title, (Object)"No title set for MediaWiki");
        try {
            HttpState httpState = new HttpState();
            if (this.shouldAuthenticate(this.username, this.password)) {
                logger.info("Authenticating to " + this.url);
                this.doAuthenticate(httpState, this.url, this.username, this.password);
                this.getEditToken(httpState, this.url, this.title);
            } else {
                this.useAnonymousToken(httpState);
            }
            logger.info("Using edit token " + httpState.getEditToken());
            this.createPage(httpState, this.url, this.title, this.text);
            logger.info("Created " + this.url + "/index.php/" + this.title);
        }
        catch (Exception e) {
            throw new GitChangelogIntegrationException(this.url + " " + this.title, e);
        }
    }

    private void useAnonymousToken(HttpState httpState) {
        httpState.setEditToken(DEFAULT_ANONYMOUS_EDIT_TOKEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPage(HttpState httpState, String url, String title, String text) throws Exception {
        URL wikiurl = new URL(url + "/api.php");
        HttpURLConnection conn = this.openConnection(wikiurl);
        try {
            conn.setRequestMethod("POST");
            HashMap params = Maps.newHashMap();
            params.put("format", "json");
            params.put("token", httpState.getEditToken());
            params.put("action", "edit");
            params.put("title", title);
            params.put("summary", "Git Changelog Plugin");
            params.put("text", this.escapeXml(text));
            if (httpState.getCookieString().isPresent()) {
                conn.setRequestProperty("Cookie", (String)httpState.getCookieString().get());
            }
            conn.setDoOutput(true);
            conn.connect();
            StringBuilder querySb = new StringBuilder();
            for (Map.Entry e : params.entrySet()) {
                querySb.append("&" + (String)e.getKey() + "=" + URLEncoder.encode((String)e.getValue(), Charsets.UTF_8.name()));
            }
            String query = querySb.toString().substring(1);
            OutputStream output = conn.getOutputStream();
            output.write(query.getBytes(Charsets.UTF_8.name()));
            String response = this.getResponse(conn);
            logger.info("Got: " + response);
        }
        finally {
            conn.disconnect();
        }
    }

    private void getEditToken(HttpState httpState, String url, String title) throws Exception {
        String response = this.postToWiki(httpState, url + "/api.php?action=query&meta=tokens&prop=info%7Crevisions&meta=tokens&rvprop=timestamp&titles=" + URLEncoder.encode(title, Charsets.UTF_8.name()) + "&format=json");
        logger.info("Response edit:\n" + response);
        String token = this.doReadFirst(response, "$..csrftoken");
        httpState.setEditToken(this.unEscapeJson(token));
    }

    private String unEscapeJson(String token) {
        return token.replaceAll("\\\\\\\\", "\\\\");
    }

    private String escapeXml(String s) {
        return s.replaceAll("\\u00C3\\u00A5", "&aring;").replaceAll("\\u00C3\\u00A4", "&auml;").replaceAll("\\u00C3\\u00B6", "&ouml;").replaceAll("\\u00C3\\u0085", "&Aring;").replaceAll("\\u00C3\\u0084", "&Auml;").replaceAll("\\u00C3\\u0096", "&Ouml;").replaceAll("(?m)^ +", "");
    }

    private void doAuthenticate(HttpState httpState, String url, String username, String password) throws Exception {
        String response = this.postToWiki(httpState, url + "/api.php?action=query&meta=tokens&format=json&type=login");
        this.getLoginToken(httpState, response);
        String postContent = "lgname=" + URLEncoder.encode(username, Charsets.UTF_8.name()) + "&lgpassword=" + URLEncoder.encode(password, Charsets.UTF_8.name()) + "&lgtoken=" + URLEncoder.encode(httpState.getLoginToken(), Charsets.UTF_8.name());
        response = this.postToWiki(httpState, url + "/api.php?action=login&format=json", postContent);
        this.doRead(response, "$.login.token");
    }

    private void getLoginToken(HttpState httpState, String response) {
        String firstElementString = this.doReadFirst(response, "$..logintoken");
        logger.info("Using logintoken: " + firstElementString);
        httpState.setLoginToken(firstElementString);
    }

    private String doReadFirst(String response, String jsonPath) {
        try {
            JSONArray tokens = (JSONArray)JsonPath.read((String)response, (String)jsonPath, (Predicate[])new Predicate[0]);
            String firstElementString = tokens.get(0).toString();
            return firstElementString;
        }
        catch (Exception e) {
            throw new RuntimeException(response + " " + jsonPath, e);
        }
    }

    private String doRead(String response, String jsonPath) {
        try {
            return (String)JsonPath.read((String)response, (String)jsonPath, (Predicate[])new Predicate[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(response + " " + jsonPath, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postToWiki(HttpState httpState, String addr, String postContent) throws GitChangelogIntegrationException {
        logger.info("Posting to: " + addr);
        HttpURLConnection conn = this.openConnection(new URL(addr));
        try {
            conn.setRequestMethod("POST");
            if (httpState.getCookieString().isPresent()) {
                logger.info("Using cookie: " + (String)httpState.getCookieString().get());
                conn.setRequestProperty("Cookie", (String)httpState.getCookieString().get());
            }
            if (postContent != null) {
                String postContentObf = postContent.replaceAll("lgpassword=([^&]+)", "lgpassword=*");
                logger.info("Post content: " + postContentObf);
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("charset", "utf-8");
                conn.setRequestProperty("Content-Length", postContent.length() + "");
                conn.setUseCaches(false);
                try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
                    wr.writeUTF(postContent);
                }
            }
            if (conn.getHeaderFields().get("Set-Cookie") != null && conn.getHeaderFields().get("Set-Cookie").size() > 0 && !httpState.getCookieString().isPresent()) {
                httpState.setCookieString(conn.getHeaderFields().get("Set-Cookie").get(0));
                logger.info("Got cookie: " + (String)httpState.getCookieString().orNull());
            }
            String response = this.getResponse(conn);
            logger.info("Response: " + response);
            String string = response;
            conn.disconnect();
            return string;
        }
        catch (Throwable throwable) {
            try {
                conn.disconnect();
                throw throwable;
            }
            catch (Exception e) {
                throw new GitChangelogIntegrationException(addr, e);
            }
        }
    }

    private String postToWiki(HttpState httpState, String addr) throws GitChangelogIntegrationException {
        return this.postToWiki(httpState, addr, null);
    }

    private boolean shouldAuthenticate(String username, String password) {
        return !Strings.isNullOrEmpty((String)username) && !Strings.isNullOrEmpty((String)password);
    }

    private static class HttpState {
        private String cookieString;
        private String editToken;
        private String loginToken;

        public void setCookieString(String cookieString) {
            this.cookieString = cookieString;
        }

        public Optional<String> getCookieString() {
            return Optional.fromNullable((Object)this.cookieString);
        }

        public String getEditToken() {
            return this.editToken;
        }

        public void setEditToken(String token) {
            this.editToken = token;
        }

        public String getLoginToken() {
            return this.loginToken;
        }

        public void setLoginToken(String loginToken) {
            this.loginToken = loginToken;
        }
    }
}

