/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.jira;

import com.google.common.base.Optional;
import java.util.concurrent.TimeUnit;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraClient;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraIssue;
import se.bjurr.gitchangelog.internal.integrations.rest.RestClient;

public class DefaultJiraClient
extends JiraClient {
    private RestClient client = new RestClient(1L, TimeUnit.MINUTES);

    public DefaultJiraClient(String api) {
        super(api);
    }

    @Override
    public JiraClient withBasicCredentials(String username, String password) {
        this.client = this.client.withBasicAuthCredentials(username, password);
        return this;
    }

    @Override
    public JiraClient withTokenCredentials(String token) {
        this.client = this.client.withTokenAuthCredentials(token);
        return this;
    }

    @Override
    public Optional<JiraIssue> getIssue(String issue) throws GitChangelogIntegrationException {
        String endpoint = this.getEndpoint(issue);
        Optional<String> json = this.client.get(endpoint);
        if (json.isPresent()) {
            JiraIssue jiraIssue = this.toJiraIssue(issue, (String)json.get());
            return Optional.of((Object)jiraIssue);
        }
        return Optional.absent();
    }
}

