/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.gitlab;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabProject;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.gitlab.GitLabIssue;
import se.bjurr.gitchangelog.internal.integrations.gitlab.GitLabProjectIssuesCacheKey;

public class GitLabClient {
    private static LoadingCache<GitLabProjectIssuesCacheKey, List<GitlabIssue>> cache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<GitLabProjectIssuesCacheKey, List<GitlabIssue>>(){

        public List<GitlabIssue> load(GitLabProjectIssuesCacheKey cacheKey) throws IOException {
            return GitLabClient.getAllIssues(cacheKey);
        }
    });
    private final String hostUrl;
    private final String apiToken;

    public GitLabClient(String hostUrl, String apiToken) {
        this.hostUrl = hostUrl;
        this.apiToken = apiToken;
    }

    public Optional<GitLabIssue> getIssue(String projectName, Integer matchedIssue) throws GitChangelogIntegrationException {
        GitlabProject project;
        GitlabAPI gitLabApi = GitlabAPI.connect((String)this.hostUrl, (String)this.apiToken);
        try {
            project = gitLabApi.getProject((Serializable)((Object)projectName));
        }
        catch (Exception e) {
            throw new GitChangelogIntegrationException("Unable to find project \"" + projectName + "\". It should be \"tomas.bjerre85/violations-test\" for a repo like: https://gitlab.com/tomas.bjerre85/violations-test", e);
        }
        Integer projectId = project.getId();
        String httpUrl = project.getHttpUrl();
        try {
            List issues = (List)cache.get((Object)new GitLabProjectIssuesCacheKey(this.hostUrl, this.apiToken, projectId));
            for (GitlabIssue candidate : issues) {
                if (candidate.getIid() != matchedIssue.intValue()) continue;
                return Optional.of((Object)this.createGitLabIssue(httpUrl, candidate));
            }
            return Optional.absent();
        }
        catch (Exception e) {
            throw new GitChangelogIntegrationException(e.getMessage(), e);
        }
    }

    private GitLabIssue createGitLabIssue(String projectUrl, GitlabIssue candidate) {
        String title = candidate.getTitle();
        String link = projectUrl + "/issues/" + candidate.getIid();
        ArrayList<String> labels = new ArrayList<String>();
        for (String l : candidate.getLabels()) {
            labels.add(l);
        }
        return new GitLabIssue(title, link, labels);
    }

    private static List<GitlabIssue> getAllIssues(GitLabProjectIssuesCacheKey cacheKey) throws IOException {
        String hostUrl = cacheKey.getHostUrl();
        String apiToken = cacheKey.getApiToken();
        GitlabAPI gitLabApi = GitlabAPI.connect((String)hostUrl, (String)apiToken);
        GitlabProject project = new GitlabProject();
        project.setId(cacheKey.getProjectId());
        return gitLabApi.getIssues(project);
    }
}

