/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.git.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.model.interfaces.IGitCommitReferer;

public class GitTag
implements IGitCommitReferer {
    private final String annotation;
    private final List<GitCommit> gitCommits;
    private final String name;
    private final Date tagTime;

    public GitTag(String name, String annotation, List<GitCommit> gitCommits, Date tagTime) {
        Preconditions.checkArgument((!gitCommits.isEmpty() ? 1 : 0) != 0, (Object)("No commits in " + name));
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.annotation = annotation;
        this.gitCommits = gitCommits;
        this.tagTime = tagTime;
    }

    public Optional<String> findAnnotation() {
        return Optional.fromNullable((Object)this.annotation);
    }

    @Override
    public GitCommit getGitCommit() {
        return (GitCommit)Preconditions.checkNotNull((Object)this.gitCommits.get(0), (Object)this.name);
    }

    public List<GitCommit> getGitCommits() {
        return this.gitCommits;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Date getTagTime() {
        return this.tagTime;
    }

    public String toString() {
        return "Tag: " + this.name + " Annotation: " + this.annotation + ", " + this.getGitCommit();
    }
}

