/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.git;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;

public class GitRepoData {
    private final List<GitCommit> gitCommits;
    private final List<GitTag> gitTags;
    private final String originCloneUrl;

    public GitRepoData(String originCloneUrl, List<GitTag> gitTags) {
        TreeSet gitCommitsSorted = Sets.newTreeSet();
        for (GitTag gitTag : gitTags) {
            gitCommitsSorted.addAll(gitTag.getGitCommits());
        }
        this.originCloneUrl = originCloneUrl;
        this.gitCommits = Lists.newArrayList((Iterable)gitCommitsSorted);
        this.gitTags = gitTags;
    }

    public String getOriginCloneUrl() {
        return this.originCloneUrl;
    }

    public List<GitCommit> getGitCommits() {
        return this.gitCommits;
    }

    public List<GitTag> getGitTags() {
        return this.gitTags;
    }

    public Optional<String> findGitHubApi() {
        if (this.originCloneUrl == null) {
            return Optional.absent();
        }
        if (!this.originCloneUrl.contains("github.com")) {
            return Optional.absent();
        }
        return Optional.of((Object)("https://api.github.com/repos/" + (String)this.findOwnerName().orNull() + "/" + (String)this.findRepoName().orNull()));
    }

    public Optional<String> findGitLabServer() {
        if (this.originCloneUrl == null) {
            return Optional.absent();
        }
        if (!this.originCloneUrl.contains("gitlab.com")) {
            return Optional.absent();
        }
        return Optional.of((Object)"https://gitlab.com/");
    }

    public Optional<String> findOwnerName() {
        return this.repoUrlPartFromEnd(1);
    }

    public Optional<String> findRepoName() {
        return this.repoUrlPartFromEnd(0);
    }

    private Optional<String> repoUrlPartFromEnd(int i) {
        if (this.originCloneUrl == null) {
            return Optional.absent();
        }
        String sequence = this.originCloneUrl.replaceAll("\\.git$", "");
        Pattern pattern = Pattern.compile("[/:]");
        Iterable parts = Splitter.on((Pattern)pattern).split((CharSequence)sequence);
        ArrayList partsList = Lists.newArrayList((Iterable)parts);
        if (partsList.size() > i) {
            return Optional.of(partsList.get(partsList.size() - i - 1));
        }
        return Optional.absent();
    }
}

