/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.common;

import com.google.common.base.Predicate;
import java.util.Date;
import java.util.regex.Pattern;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.settings.Settings;

public class GitPredicates {
    public static Predicate<GitCommit> ignoreCommits(final Settings settings) {
        return new Predicate<GitCommit>(){

            public boolean apply(GitCommit gitCommit) {
                boolean olderThan;
                boolean messageMatches = Pattern.compile(settings.getIgnoreCommitsIfMessageMatches(), 32).matcher(gitCommit.getMessage()).matches();
                if (messageMatches) {
                    return false;
                }
                return !settings.getIgnoreCommitsIfOlderThan().isPresent() || !(olderThan = gitCommit.getCommitTime().before((Date)settings.getIgnoreCommitsIfOlderThan().get()));
            }
        };
    }
}

