/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.model;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import se.bjurr.gitchangelog.api.model.Issue;
import se.bjurr.gitchangelog.internal.settings.SettingsIssueType;

public class IssueType
implements Serializable {
    private static final long serialVersionUID = 8850522973130773606L;
    private final String name;
    private final List<Issue> issues;
    private final SettingsIssueType type;

    public IssueType(List<Issue> issues, String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.issues = (List)Preconditions.checkNotNull(issues, (Object)"issues");
        Preconditions.checkState((!issues.isEmpty() ? 1 : 0) != 0, (Object)"Issues empty!");
        this.type = issues.get(0).getIssueType();
    }

    public SettingsIssueType getType() {
        return this.type;
    }

    public boolean isJira() {
        return this.type == SettingsIssueType.JIRA;
    }

    public boolean isGitHub() {
        return this.type == SettingsIssueType.GITHUB;
    }

    public boolean isGitLab() {
        return this.type == SettingsIssueType.GITLAB;
    }

    public boolean isCustom() {
        return this.type == SettingsIssueType.CUSTOM;
    }

    public boolean isNoIssue() {
        return this.type == SettingsIssueType.NOISSUE;
    }

    public String getName() {
        return this.name;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public String toString() {
        return "IssueType: " + this.name;
    }
}

