/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Commit
implements Serializable {
    private static final long serialVersionUID = 6622555148468372816L;
    private final String authorEmailAddress;
    private final String authorName;
    private final String commitTime;
    private final Long commitTimeLong;
    private final String hash;
    private final String hashFull;
    private final Boolean merge;
    private final String message;

    private static List<String> notFirst(List<String> stringList) {
        return stringList.subList(1, stringList.size());
    }

    private static String toHash(String input) {
        return input.substring(0, 15);
    }

    private static List<String> toNoEmptyStringsList(String message) {
        ArrayList toReturn = Lists.newArrayList();
        for (String part : Splitter.on((String)"\n").split((CharSequence)message)) {
            if (part.isEmpty()) continue;
            toReturn.add(part);
        }
        return toReturn;
    }

    @VisibleForTesting
    static String toMessageBody(String message) {
        List<String> stringList = Commit.toNoEmptyStringsList(message);
        if (stringList.size() > 1) {
            List<String> notFirst = Commit.notFirst(stringList);
            return Joiner.on((String)"\n").join(notFirst);
        }
        return "";
    }

    @VisibleForTesting
    static List<String> toMessageItems(String message) {
        ArrayList toReturn = Lists.newArrayList();
        List<String> stringList = Commit.toNoEmptyStringsList(message);
        if (stringList.size() > 1) {
            List<String> notFirst = Commit.notFirst(stringList);
            for (String part : notFirst) {
                String candidate = part.trim();
                if (candidate.startsWith("*")) {
                    candidate = candidate.substring(1).trim();
                }
                if (candidate.isEmpty()) continue;
                toReturn.add(candidate);
            }
        }
        return toReturn;
    }

    @VisibleForTesting
    static String toMessageTitle(String message) {
        List<String> stringList = Commit.toNoEmptyStringsList(message);
        if (stringList.size() > 0) {
            return stringList.get(0).trim();
        }
        return "";
    }

    public Commit(String authorName, String authorEmailAddress, String commitTime, Long commitTimeLong, String message, String hash, Boolean merge) {
        this.authorName = (String)Preconditions.checkNotNull((Object)authorName, (Object)"authorName");
        this.authorEmailAddress = (String)Preconditions.checkNotNull((Object)authorEmailAddress, (Object)"authorEmailAddress");
        this.message = ((String)Preconditions.checkNotNull((Object)message, (Object)"message")).trim();
        this.commitTime = (String)Preconditions.checkNotNull((Object)commitTime, (Object)"commitTime");
        this.commitTimeLong = (Long)Preconditions.checkNotNull((Object)commitTimeLong, (Object)"commitTimeLong");
        this.hash = Commit.toHash((String)Preconditions.checkNotNull((Object)hash, (Object)"hash"));
        this.hashFull = (String)Preconditions.checkNotNull((Object)hash, (Object)"hashFull");
        this.merge = (Boolean)Preconditions.checkNotNull((Object)merge, (Object)"merge");
    }

    public String getAuthorEmailAddress() {
        return this.authorEmailAddress;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getCommitTime() {
        return this.commitTime;
    }

    public Long getCommitTimeLong() {
        return this.commitTimeLong;
    }

    public String getHash() {
        return this.hash;
    }

    public String getHashFull() {
        return this.hashFull;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageBody() {
        return Commit.toMessageBody(this.message);
    }

    public List<String> getMessageBodyItems() {
        return Commit.toMessageItems(this.message);
    }

    public String getMessageTitle() {
        return Commit.toMessageTitle(this.message);
    }

    public Boolean isMerge() {
        return this.merge;
    }

    public String toString() {
        return "hash: " + this.hash + " message: " + this.message;
    }
}

