/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectId;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogRepositoryException;
import se.bjurr.gitchangelog.api.model.Changelog;
import se.bjurr.gitchangelog.internal.git.GitRepo;
import se.bjurr.gitchangelog.internal.git.GitRepoData;
import se.bjurr.gitchangelog.internal.git.GitRepoDataHelper;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;
import se.bjurr.gitchangelog.internal.integrations.mediawiki.MediaWikiClient;
import se.bjurr.gitchangelog.internal.issues.IssueParser;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;
import se.bjurr.gitchangelog.internal.model.Transformer;
import se.bjurr.gitchangelog.internal.settings.Settings;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;

public class GitChangelogApi {
    private Settings settings;
    private String templateContent;

    public static GitChangelogApi gitChangelogApiBuilder() {
        return new GitChangelogApi();
    }

    private GitChangelogApi() {
        this.settings = new Settings();
    }

    private GitChangelogApi(Settings settings) {
        this.settings = settings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Changelog getChangelog(boolean useIntegrationIfConfigured) throws GitChangelogRepositoryException {
        try (GitRepo gitRepo = new GitRepo(new File(this.settings.getFromRepo()));){
            Changelog changelog = this.getChangelog(gitRepo, useIntegrationIfConfigured);
            return changelog;
        }
        catch (IOException e) {
            throw new GitChangelogRepositoryException("", e);
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void render(Writer writer) throws GitChangelogRepositoryException {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        String templateContent = (String)Preconditions.checkNotNull((Object)this.getTemplateContent(), (Object)"No template!");
        StringReader reader = new StringReader(templateContent);
        Mustache mustache = mf.compile((Reader)reader, this.settings.getTemplatePath());
        try {
            boolean useIntegrationIfConfigured = GitChangelogApi.shouldUseIntegrationIfConfigured(templateContent);
            Changelog changelog = this.getChangelog(useIntegrationIfConfigured);
            mustache.execute(writer, new Object[]{changelog, this.settings.getExtendedVariables()}).flush();
        }
        catch (IOException e) {
            throw new GitChangelogRepositoryException("", e);
        }
    }

    @VisibleForTesting
    static boolean shouldUseIntegrationIfConfigured(String templateContent) {
        return templateContent.contains("{{type}}") || templateContent.contains("{{link}}") || templateContent.contains("{{title}}") || templateContent.replaceAll("\\r?\\n", " ").matches(".*\\{\\{#?labels\\}\\}.*");
    }

    public String render() throws GitChangelogRepositoryException {
        StringWriter writer = new StringWriter();
        this.render(writer);
        return ((Object)writer).toString();
    }

    public void toFile(File file) throws GitChangelogRepositoryException, IOException {
        Files.createParentDirs((File)file);
        Files.write((byte[])this.render().getBytes("UTF-8"), (File)file);
    }

    public void toMediaWiki(String username, String password, String url, String title) throws GitChangelogRepositoryException, GitChangelogIntegrationException {
        new MediaWikiClient(url, title, this.render()).withUser(username, password).createMediaWikiPage();
    }

    public GitChangelogApi withCustomIssue(String name, String pattern, String link, String title) {
        this.settings.addCustomIssue(new SettingsIssue(name, pattern, link, title));
        return this;
    }

    public GitChangelogApi withDateFormat(String dateFormat) {
        this.settings.setDateFormat(dateFormat);
        return this;
    }

    public GitChangelogApi withExtendedVariables(Map<String, Object> extendedVariables) {
        this.settings.setExtendedVariables(extendedVariables);
        return this;
    }

    public GitChangelogApi withFromCommit(String fromCommit) {
        this.settings.setFromCommit(fromCommit);
        return this;
    }

    public GitChangelogApi withFromRef(String fromBranch) {
        this.settings.setFromRef(fromBranch);
        return this;
    }

    public GitChangelogApi withFromRepo(String fromRepo) {
        this.settings.setFromRepo(fromRepo);
        return this;
    }

    public GitChangelogApi withGitHubApi(String gitHubApi) {
        this.settings.setGitHubApi(gitHubApi);
        return this;
    }

    public GitChangelogApi withGitHubIssuePattern(String gitHubIssuePattern) {
        this.settings.setGitHubIssuePattern(gitHubIssuePattern);
        return this;
    }

    public GitChangelogApi withGitHubToken(String gitHubToken) {
        this.settings.setGitHubToken(gitHubToken);
        return this;
    }

    public GitChangelogApi withGitLabIssuePattern(String gitLabIssuePattern) {
        this.settings.setGitLabIssuePattern(gitLabIssuePattern);
        return this;
    }

    public GitChangelogApi withGitLabProjectName(String gitLabProjectName) {
        this.settings.setGitLabProjectName(gitLabProjectName);
        return this;
    }

    public GitChangelogApi withGitLabServer(String gitLabServer) {
        this.settings.setGitLabServer(gitLabServer);
        return this;
    }

    public GitChangelogApi withGitLabToken(String gitLabToken) {
        this.settings.setGitLabToken(gitLabToken);
        return this;
    }

    public GitChangelogApi withIgnoreCommitsWithMessage(String ignoreCommitsIfMessageMatches) {
        this.settings.setIgnoreCommitsIfMessageMatches(ignoreCommitsIfMessageMatches);
        return this;
    }

    public GitChangelogApi withIgnoreCommitsOlderThan(Date ignoreCommitsIfOlderThan) {
        this.settings.setIgnoreCommitsIfOlderThan(ignoreCommitsIfOlderThan);
        return this;
    }

    public GitChangelogApi withIgnoreCommitsWithoutIssue(boolean ignoreCommitsWithoutIssue) {
        this.settings.setIgnoreCommitsWithoutIssue(ignoreCommitsWithoutIssue);
        return this;
    }

    public GitChangelogApi withIgnoreTagsIfNameMatches(String ignoreTagsIfNameMatches) {
        this.settings.setIgnoreTagsIfNameMatches(ignoreTagsIfNameMatches);
        return this;
    }

    public GitChangelogApi withJiraIssuePattern(String jiraIssuePattern) {
        this.settings.setJiraIssuePattern(jiraIssuePattern);
        return this;
    }

    public GitChangelogApi withJiraPassword(String string) {
        this.settings.setJiraPassword(string);
        return this;
    }

    public GitChangelogApi withJiraBasicAuthString(String string) {
        this.settings.setJiraToken(string);
        return this;
    }

    public GitChangelogApi withJiraServer(String jiraServer) {
        this.settings.setJiraServer(jiraServer);
        return this;
    }

    public GitChangelogApi withJiraUsername(String string) {
        this.settings.setJiraUsername(string);
        return this;
    }

    public GitChangelogApi withNoIssueName(String noIssueName) {
        this.settings.setNoIssueName(noIssueName);
        return this;
    }

    public GitChangelogApi withReadableTagName(String readableTagName) {
        this.settings.setReadableTagName(readableTagName);
        return this;
    }

    public GitChangelogApi withRemoveIssueFromMessageArgument(boolean removeIssueFromMessage) {
        this.settings.setRemoveIssueFromMessage(removeIssueFromMessage);
        return this;
    }

    public GitChangelogApi withSettings(URL url) {
        this.settings = Settings.fromFile(url);
        return this;
    }

    public GitChangelogApi withTemplateContent(String templateContent) {
        this.templateContent = templateContent;
        return this;
    }

    public GitChangelogApi withTemplatePath(String templatePath) {
        this.settings.setTemplatePath(templatePath);
        return this;
    }

    public GitChangelogApi withTimeZone(String timeZone) {
        this.settings.setTimeZone(timeZone);
        return this;
    }

    public GitChangelogApi withToCommit(String toCommit) {
        this.settings.setToCommit(toCommit);
        return this;
    }

    public GitChangelogApi withToRef(String toBranch) {
        this.settings.setToRef(toBranch);
        return this;
    }

    public GitChangelogApi withUntaggedName(String untaggedName) {
        this.settings.setUntaggedName(untaggedName);
        return this;
    }

    private Changelog getChangelog(GitRepo gitRepo, boolean useIntegrationIfConfigured) throws GitChangelogRepositoryException {
        ObjectId fromId = (ObjectId)this.getId(gitRepo, this.settings.getFromRef(), this.settings.getFromCommit()).or((Object)gitRepo.getCommit("0000000000000000000000000000000000000000"));
        Optional<ObjectId> toIdOpt = this.getId(gitRepo, this.settings.getToRef(), this.settings.getToCommit());
        ObjectId toId = toIdOpt.isPresent() ? (ObjectId)toIdOpt.get() : gitRepo.getRef("master");
        GitRepoData gitRepoData = gitRepo.getGitRepoData(fromId, toId, this.settings.getUntaggedName(), this.settings.getIgnoreTagsIfNameMatches());
        if (!this.settings.getGitHubApi().isPresent()) {
            this.settings.setGitHubApi((String)gitRepoData.findGitHubApi().orNull());
        }
        if (!this.settings.getGitLabServer().isPresent()) {
            this.settings.setGitLabServer((String)gitRepoData.findGitLabServer().orNull());
            this.settings.setGitLabProjectName((String)gitRepoData.findOwnerName().orNull());
        }
        List<GitCommit> diff = gitRepoData.getGitCommits();
        List<ParsedIssue> issues = new IssueParser(this.settings, diff).parseForIssues(useIntegrationIfConfigured);
        if (this.settings.ignoreCommitsWithoutIssue()) {
            gitRepoData = GitRepoDataHelper.removeCommitsWithoutIssue(issues, gitRepoData);
            diff = gitRepoData.getGitCommits();
        }
        List<GitTag> tags = gitRepoData.getGitTags();
        Transformer transformer = new Transformer(this.settings);
        return new Changelog(transformer.toCommits(diff), transformer.toTags(tags, issues), transformer.toAuthors(diff), transformer.toIssues(issues), transformer.toIssueTypes(issues), (String)gitRepoData.findOwnerName().orNull(), (String)gitRepoData.findRepoName().orNull());
    }

    private Optional<ObjectId> getId(GitRepo gitRepo, Optional<String> ref, Optional<String> commit) throws GitChangelogRepositoryException {
        if (ref.isPresent()) {
            return Optional.of((Object)gitRepo.getRef((String)ref.get()));
        }
        if (commit.isPresent()) {
            return Optional.of((Object)gitRepo.getCommit((String)commit.get()));
        }
        return Optional.absent();
    }

    private String getTemplateContent() {
        if (this.templateContent != null) {
            return this.templateContent;
        }
        Preconditions.checkArgument((this.settings.getTemplatePath() != null ? 1 : 0) != 0, (Object)"You must specify a template!");
        try {
            return Resources.toString((URL)Resources.getResource((String)this.settings.getTemplatePath()), (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            File file = null;
            try {
                file = new File(this.settings.getTemplatePath());
                return Files.toString((File)file, (Charset)Charsets.UTF_8);
            }
            catch (IOException e2) {
                throw new RuntimeException("Cannot find on classpath (" + this.settings.getTemplatePath() + ") or filesystem (" + file.getAbsolutePath() + ").", e2);
            }
        }
    }
}

