/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.model.interfaces.IGitCommitReferer;

public class ParsedIssue
implements IGitCommitReferer {
    private final List<GitCommit> gitCommits = Lists.newArrayList();
    private final String name;
    private final String title;
    private final String link;
    private final String issue;
    private final String issueType;
    private final List<String> labels;

    public ParsedIssue(String name, String issue, String link, String title, String issueType, List<String> labels) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.title = Strings.emptyToNull((String)title);
        this.issue = issue;
        this.link = link;
        this.issueType = issueType;
        this.labels = labels;
    }

    public Optional<String> getTitle() {
        return Optional.fromNullable((Object)this.title);
    }

    @Override
    public GitCommit getGitCommit() {
        return (GitCommit)Preconditions.checkNotNull((Object)this.gitCommits.get(0), (Object)this.name);
    }

    public List<GitCommit> getGitCommits() {
        return this.gitCommits;
    }

    public String getLink() {
        return this.link;
    }

    public String getIssueType() {
        return this.issueType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.name + this.issue;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != ParsedIssue.class) {
            return false;
        }
        return this.name.equals(((ParsedIssue)obj).getName());
    }

    public void addCommit(GitCommit gitCommit) {
        this.gitCommits.add(gitCommit);
    }

    public String getIssue() {
        return this.issue;
    }

    public void addCommits(List<GitCommit> commits) {
        this.gitCommits.addAll(commits);
    }

    public List<String> getLabels() {
        return this.labels;
    }
}

