/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;

public class RestClient {
    private static Logger logger = LoggerFactory.getLogger(RestClient.class);
    private static RestClient mockedRestClient;
    private final LoadingCache<String, Optional<String>> urlCache;
    private String basicAuthString;

    public RestClient(long duration, TimeUnit cacheExpireAfterAccess) {
        this.urlCache = CacheBuilder.newBuilder().expireAfterAccess(duration, cacheExpireAfterAccess).build((CacheLoader)new CacheLoader<String, Optional<String>>(){

            public Optional<String> load(String url) throws Exception {
                return RestClient.this.doGet(url);
            }
        });
    }

    public RestClient withBasicAuthCredentials(String username, String password) {
        this.basicAuthString = new String(DatatypeConverter.printBase64Binary((byte[])(username + ":" + password).getBytes()));
        return this;
    }

    public Optional<String> get(String url) throws GitChangelogIntegrationException {
        try {
            return (Optional)this.urlCache.get((Object)url);
        }
        catch (Exception e) {
            throw new GitChangelogIntegrationException("Problems invoking " + url, e);
        }
    }

    private Optional<String> doGet(String urlParam) {
        String response = null;
        try {
            logger.info("GET:\n" + urlParam);
            URL url = new URL(urlParam);
            HttpURLConnection conn = this.openConnection(url);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            if (this.basicAuthString != null) {
                conn.setRequestProperty("Authorization", "Basic " + this.basicAuthString);
            }
            return Optional.of((Object)this.getResponse(conn));
        }
        catch (Exception e) {
            logger.error("Got:\n" + response, (Throwable)e);
            return Optional.absent();
        }
    }

    @VisibleForTesting
    protected HttpURLConnection openConnection(URL url) throws Exception {
        if (mockedRestClient == null) {
            return (HttpURLConnection)url.openConnection();
        }
        return mockedRestClient.openConnection(url);
    }

    @VisibleForTesting
    protected String getResponse(HttpURLConnection conn) throws Exception {
        if (mockedRestClient == null) {
            return new String(ByteStreams.toByteArray((InputStream)conn.getInputStream()));
        }
        return mockedRestClient.getResponse(conn);
    }

    public static void mock(RestClient mock) {
        mockedRestClient = mock;
    }
}

