/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.jira;

import com.google.common.base.Optional;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraIssue;

public abstract class JiraClient {
    private final String api;

    public JiraClient(String api) {
        this.api = api.endsWith("/") ? api.substring(0, api.length() - 1) : api;
    }

    public String getApi() {
        return this.api;
    }

    protected String getEndpoint(String issue) {
        String endpoint = this.api + "/rest/api/2/issue/" + issue + "?fields=parent,summary,issuetype,labels";
        return endpoint;
    }

    protected JiraIssue toJiraIssue(String issue, String json) {
        String title = (String)JsonPath.read((String)json, (String)"$.fields.summary", (Predicate[])new Predicate[0]);
        String type = (String)JsonPath.read((String)json, (String)"$.fields.issuetype.name", (Predicate[])new Predicate[0]);
        String link = this.api + "/browse/" + issue;
        List labels = (List)JsonPath.read((String)json, (String)"$.fields.labels", (Predicate[])new Predicate[0]);
        JiraIssue jiraIssue = new JiraIssue(title, link, issue, type, labels);
        return jiraIssue;
    }

    public abstract JiraClient withBasicCredentials(String var1, String var2);

    public abstract Optional<JiraIssue> getIssue(String var1) throws GitChangelogIntegrationException;
}

