/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.github;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubService;

public class GitHubServiceFactory {
    private static GitHubService gitHubService = null;

    public static void reset() {
        gitHubService = null;
    }

    public static GitHubService getGitHubService(String api, Optional<String> token) {
        return GitHubServiceFactory.getGitHubService(api, token, null);
    }

    public static synchronized GitHubService getGitHubService(String api, final Optional<String> token, Interceptor interceptor) {
        if (!api.endsWith("/")) {
            api = api + "/";
        }
        if (gitHubService == null) {
            File cacheDir = new File(".okhttpcache");
            cacheDir.mkdir();
            Cache cache = new Cache(cacheDir, 0xA00000L);
            OkHttpClient.Builder builder = new OkHttpClient.Builder().cache(cache).connectTimeout(10L, TimeUnit.SECONDS);
            if (token != null && token.isPresent() && !((String)token.get()).isEmpty()) {
                builder.addInterceptor(new Interceptor(){

                    public Response intercept(Interceptor.Chain chain) throws IOException {
                        Request original = chain.request();
                        Request request = original.newBuilder().addHeader("Authorization", "token " + (String)token.get()).method(original.method(), original.body()).build();
                        return chain.proceed(request);
                    }
                });
            }
            if (interceptor != null) {
                builder.addInterceptor(interceptor);
            }
            Retrofit retrofit = new Retrofit.Builder().baseUrl(api).client(builder.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
            gitHubService = (GitHubService)retrofit.create(GitHubService.class);
        }
        return gitHubService;
    }
}

