/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.git;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import se.bjurr.gitchangelog.internal.git.GitRepoData;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;

public class GitRepoDataHelper {
    public static GitRepoData removeCommitsWithoutIssue(List<ParsedIssue> allParsedIssues, GitRepoData gitRepoData) {
        TreeSet commitsWithIssues = Sets.newTreeSet();
        for (ParsedIssue parsedIssue : allParsedIssues) {
            for (GitCommit gitCommit : parsedIssue.getGitCommits()) {
                commitsWithIssues.add(gitCommit);
            }
        }
        ArrayList reducedGitCommits = Lists.newArrayList((Iterable)commitsWithIssues);
        ArrayList reducedGitTags = Lists.newArrayList();
        for (GitTag gitTag : gitRepoData.getGitTags()) {
            Iterable reducedCommitsInTag = Iterables.filter(gitTag.getGitCommits(), (Predicate)Predicates.in((Collection)reducedGitCommits));
            if (Iterables.isEmpty((Iterable)reducedCommitsInTag)) continue;
            reducedGitTags.add(new GitTag(gitTag.getName(), (String)gitTag.findAnnotation().orNull(), Lists.newArrayList((Iterable)reducedCommitsInTag)));
        }
        return new GitRepoData(reducedGitTags);
    }

    private GitRepoDataHelper() {
    }
}

