/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.git;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogRepositoryException;
import se.bjurr.gitchangelog.internal.git.GitRepoData;
import se.bjurr.gitchangelog.internal.git.TraversalWork;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;

public class GitRepo
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(GitRepo.class);
    private List<RevCommit> commitsToInclude;
    private Git git;
    private final Repository repository;
    private final RevWalk revWalk;

    public GitRepo() {
        this.repository = null;
        this.revWalk = null;
    }

    public GitRepo(File repo) throws GitChangelogRepositoryException {
        try {
            FileRepositoryBuilder builder;
            File repoFile = new File(repo.getAbsolutePath());
            File gitRepoFile = new File(repo.getAbsolutePath() + "/.git");
            if (gitRepoFile.exists()) {
                repoFile = gitRepoFile;
            }
            if ((builder = (FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(repoFile)).readEnvironment()).getGitDir() == null) {
                throw new GitChangelogRepositoryException("Did not find a GIT repo in " + repo.getAbsolutePath());
            }
            this.repository = builder.build();
            this.revWalk = new RevWalk(this.repository);
            this.git = new Git(this.repository);
        }
        catch (IOException e) {
            throw new GitChangelogRepositoryException("Could not use GIT repo in " + repo.getAbsolutePath(), e);
        }
    }

    @Override
    public void close() throws IOException {
        this.git.close();
        this.repository.close();
    }

    public ObjectId getCommit(String fromCommit) throws GitChangelogRepositoryException {
        if (fromCommit.startsWith("0000000000000000000000000000000000000000")) {
            return this.firstCommit();
        }
        try {
            return this.repository.resolve(fromCommit);
        }
        catch (Exception e) {
            throw new GitChangelogRepositoryException("", e);
        }
    }

    public GitRepoData getGitRepoData(ObjectId from, ObjectId to, String untaggedName, Optional<String> ignoreTagsIfNameMatches) throws GitChangelogRepositoryException {
        try {
            return new GitRepoData(this.gitTags(from, to, untaggedName, ignoreTagsIfNameMatches));
        }
        catch (Exception e) {
            throw new GitChangelogRepositoryException(this.toString(), e);
        }
    }

    public ObjectId getRef(String fromRef) throws GitChangelogRepositoryException {
        try {
            for (Ref foundRef : this.getAllRefs().values()) {
                if (!foundRef.getName().endsWith(fromRef)) continue;
                Ref ref = this.getAllRefs().get(foundRef.getName());
                Ref peeledRef = this.repository.peel(ref);
                if (peeledRef.getPeeledObjectId() != null) {
                    return peeledRef.getPeeledObjectId();
                }
                return ref.getObjectId();
            }
            throw new GitChangelogRepositoryException(fromRef + " not found in:\n" + this.toString());
        }
        catch (Exception e) {
            throw new GitChangelogRepositoryException("", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Ref foundRef : this.getAllRefs().values()) {
            sb.append(foundRef.getName() + "\n");
        }
        return "Repo: " + this.repository + "\n" + sb.toString();
    }

    private void addCommitToCurrentTag(Map<String, Set<GitCommit>> commitsPerTagName, String currentTagName, RevCommit thisCommit) {
        GitCommit gitCommit = this.toGitCommit(thisCommit);
        if (!commitsPerTagName.containsKey(currentTagName)) {
            commitsPerTagName.put(currentTagName, new TreeSet());
        }
        Set<GitCommit> gitCommitsInCurrentTag = commitsPerTagName.get(currentTagName);
        gitCommitsInCurrentTag.add(gitCommit);
    }

    private void addToTags(Map<String, Set<GitCommit>> commitsPerTag, String tagName, List<GitTag> addTo, Map<String, RevTag> annotatedTagPerTagName) {
        if (commitsPerTag.containsKey(tagName)) {
            Set<GitCommit> gitCommits = commitsPerTag.get(tagName);
            boolean isAnnotated = annotatedTagPerTagName.containsKey(tagName);
            String annotation = null;
            if (isAnnotated) {
                annotation = annotatedTagPerTagName.get(tagName).getFullMessage();
            }
            GitTag gitTag = new GitTag(tagName, annotation, Lists.newArrayList(gitCommits));
            addTo.add(gitTag);
        }
    }

    private RevCommit firstCommit() {
        try (Git git = null;){
            git = new Git(this.repository);
            ObjectId master = this.getRef("HEAD");
            Iterator itr = git.log().add((AnyObjectId)master).call().iterator();
            RevCommit revCommit = (RevCommit)Iterators.getLast(itr);
            return revCommit;
        }
    }

    private Map<String, Ref> getAllRefs() {
        return this.repository.getAllRefs();
    }

    private Map<String, RevTag> getAnnotatedTagPerTagName(Optional<String> ignoreTagsIfNameMatches, List<Ref> tagList) {
        HashMap tagPerCommit = Maps.newHashMap();
        for (Ref tag : tagList) {
            Ref peeledTag;
            if (ignoreTagsIfNameMatches.isPresent() && Pattern.compile((String)ignoreTagsIfNameMatches.get()).matcher(tag.getName()).matches() || (peeledTag = this.repository.peel(tag)).getPeeledObjectId() == null) continue;
            try {
                RevTag revTag = RevTag.parse((byte[])this.repository.open((AnyObjectId)tag.getObjectId()).getBytes());
                tagPerCommit.put(tag.getName(), revTag);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return tagPerCommit;
    }

    private List<RevCommit> getDiffingCommits(RevCommit from, RevCommit to) throws Exception {
        RevCommit firstCommit = this.firstCommit();
        ArrayList allInFrom = Lists.newArrayList((Iterable)this.git.log().addRange((AnyObjectId)firstCommit, (AnyObjectId)from).call());
        ArrayList allInTo = Lists.newArrayList((Iterable)this.git.log().addRange((AnyObjectId)firstCommit, (AnyObjectId)to).call());
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)allInTo, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)allInFrom))));
    }

    private ObjectId getPeeled(Ref tag) {
        Ref peeledTag = this.repository.peel(tag);
        if (peeledTag.getPeeledObjectId() != null) {
            return peeledTag.getPeeledObjectId();
        }
        return tag.getObjectId();
    }

    private List<Ref> getTagCommitHashSortedByCommitTime(Collection<Ref> refs) {
        return Ordering.from((Comparator)new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                RevCommit revCommit1 = GitRepo.this.revWalk.lookupCommit((AnyObjectId)GitRepo.this.getPeeled(o1));
                try {
                    GitRepo.this.revWalk.parseHeaders((RevObject)revCommit1);
                    RevCommit revCommit2 = GitRepo.this.revWalk.lookupCommit((AnyObjectId)GitRepo.this.getPeeled(o2));
                    GitRepo.this.revWalk.parseHeaders((RevObject)revCommit2);
                    return GitRepo.this.toGitCommit(revCommit1).compareTo(GitRepo.this.toGitCommit(revCommit2));
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }).sortedCopy(refs);
    }

    private String getTagName(Map<String, Ref> tagPerCommitHash, String thisCommitHash) {
        return tagPerCommitHash.get(thisCommitHash).getName();
    }

    private Map<String, Ref> getTagPerCommitHash(Optional<String> ignoreTagsIfNameMatches, List<Ref> tagList) {
        HashMap tagPerCommit = Maps.newHashMap();
        for (Ref tag : tagList) {
            if (ignoreTagsIfNameMatches.isPresent() && Pattern.compile((String)ignoreTagsIfNameMatches.get()).matcher(tag.getName()).matches()) continue;
            tagPerCommit.put(this.getPeeled(tag).getName(), tag);
        }
        return tagPerCommit;
    }

    private List<GitTag> gitTags(ObjectId fromObjectId, ObjectId toObjectId, String untaggedName, Optional<String> ignoreTagsIfNameMatches) throws Exception {
        RevCommit from = this.revWalk.lookupCommit((AnyObjectId)fromObjectId);
        RevCommit to = this.revWalk.lookupCommit((AnyObjectId)toObjectId);
        this.commitsToInclude = this.getDiffingCommits(from, to);
        List<Ref> tagList = this.tagsBetweenFromAndTo((ObjectId)from, (ObjectId)to);
        Map<String, Ref> tagPerCommitHash = this.getTagPerCommitHash(ignoreTagsIfNameMatches, tagList);
        Map<String, RevTag> annotatedTagPerTagName = this.getAnnotatedTagPerTagName(ignoreTagsIfNameMatches, tagList);
        HashMap tagPerCommitsHash = Maps.newHashMap();
        HashMap commitsPerTag = Maps.newHashMap();
        this.populateComitPerTag(from, (ObjectId)to, tagPerCommitHash, tagPerCommitsHash, commitsPerTag, null);
        this.populateComitPerTag(from, (ObjectId)to, tagPerCommitHash, tagPerCommitsHash, commitsPerTag, untaggedName);
        ArrayList tags = Lists.newArrayList();
        this.addToTags(commitsPerTag, untaggedName, tags, annotatedTagPerTagName);
        List<Ref> tagCommitHashSortedByCommitTime = this.getTagCommitHashSortedByCommitTime(tagPerCommitHash.values());
        for (Ref tag : tagCommitHashSortedByCommitTime) {
            this.addToTags(commitsPerTag, tag.getName(), tags, annotatedTagPerTagName);
        }
        return tags;
    }

    private boolean isMappedToAnotherTag(Map<String, String> tagPerCommitsHash, String thisCommitHash) {
        return tagPerCommitsHash.containsKey(thisCommitHash);
    }

    private String noteThatTheCommitWasMapped(Map<String, String> tagPerCommitsHash, String currentTagName, String thisCommitHash) {
        return tagPerCommitsHash.put(thisCommitHash, currentTagName);
    }

    private boolean notFirstIncludedCommit(ObjectId from, ObjectId to) {
        return !from.getName().equals(to.getName());
    }

    private void populateComitPerTag(RevCommit from, ObjectId to, Map<String, Ref> tagPerCommitHash, Map<String, String> tagPerCommitsHash, Map<String, Set<GitCommit>> commitsPerTag, String startingTagName) throws Exception {
        Set<TraversalWork> moreWork = this.populateCommitPerTag(from, to, commitsPerTag, tagPerCommitHash, tagPerCommitsHash, startingTagName);
        do {
            TreeSet evenMoreWork = Sets.newTreeSet();
            for (TraversalWork tw : Lists.newArrayList(moreWork)) {
                moreWork.remove(tw);
                Set<TraversalWork> newWork = this.populateCommitPerTag(from, (ObjectId)tw.getTo(), commitsPerTag, tagPerCommitHash, tagPerCommitsHash, tw.getCurrentTagName());
                evenMoreWork.addAll(newWork);
            }
            moreWork.addAll(evenMoreWork);
            LOG.debug("Work left: " + moreWork.size());
        } while (!moreWork.isEmpty());
    }

    private Set<TraversalWork> populateCommitPerTag(RevCommit from, ObjectId to, Map<String, Set<GitCommit>> commitsPerTagName, Map<String, Ref> tagPerCommitHash, Map<String, String> tagPerCommitsHash, String currentTagName) throws Exception {
        String thisCommitHash = to.getName();
        if (this.isMappedToAnotherTag(tagPerCommitsHash, thisCommitHash)) {
            return Sets.newTreeSet();
        }
        RevCommit thisCommit = this.revWalk.lookupCommit((AnyObjectId)to);
        this.revWalk.parseHeaders((RevObject)thisCommit);
        if (this.thisIsANewTag(tagPerCommitHash, thisCommitHash)) {
            currentTagName = this.getTagName(tagPerCommitHash, thisCommitHash);
        }
        if (currentTagName != null) {
            this.addCommitToCurrentTag(commitsPerTagName, currentTagName, thisCommit);
            this.noteThatTheCommitWasMapped(tagPerCommitsHash, currentTagName, thisCommitHash);
        }
        if (this.notFirstIncludedCommit((ObjectId)from, to)) {
            TreeSet work = Sets.newTreeSet();
            for (RevCommit parent : thisCommit.getParents()) {
                if (!this.shouldInclude(parent)) continue;
                work.add(new TraversalWork(parent, currentTagName));
            }
            return work;
        }
        return Sets.newTreeSet();
    }

    private boolean shouldInclude(RevCommit candidate) throws Exception {
        return this.commitsToInclude.contains(candidate);
    }

    private List<Ref> tagsBetweenFromAndTo(ObjectId from, ObjectId to) throws Exception {
        List tagList = this.git.tagList().call();
        ArrayList icludedCommits = Lists.newArrayList((Iterable)this.git.log().addRange((AnyObjectId)from, (AnyObjectId)to).call());
        ArrayList includedTags = Lists.newArrayList();
        for (Ref tag : tagList) {
            ObjectId peeledTag = this.getPeeled(tag);
            if (!icludedCommits.contains(peeledTag)) continue;
            includedTags.add(tag);
        }
        return includedTags;
    }

    private boolean thisIsANewTag(Map<String, Ref> tagsPerCommitHash, String thisCommitHash) {
        return tagsPerCommitHash.containsKey(thisCommitHash);
    }

    private GitCommit toGitCommit(RevCommit revCommit) {
        Boolean merge = revCommit.getParentCount() > 1;
        return new GitCommit(revCommit.getAuthorIdent().getName(), revCommit.getAuthorIdent().getEmailAddress(), new Date((long)revCommit.getCommitTime() * 1000L), revCommit.getFullMessage(), revCommit.getId().getName(), merge);
    }
}

