/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.List;
import se.bjurr.gitchangelog.api.model.Author;
import se.bjurr.gitchangelog.api.model.Commit;
import se.bjurr.gitchangelog.api.model.interfaces.IAuthors;
import se.bjurr.gitchangelog.api.model.interfaces.ICommits;

public class Issue
implements ICommits,
IAuthors,
Serializable {
    private static final long serialVersionUID = -7571341639024417199L;
    private final List<Commit> commits;
    private final List<Author> authors;
    private final String name;
    private final String title;
    private final boolean hasTitle;
    private final String issue;
    private final boolean hasIssue;
    private final String link;
    private final boolean hasLink;
    private final String type;
    private final boolean hasType;
    private final List<String> labels;
    private final boolean hasLabels;

    public Issue(List<Commit> commits, List<Author> authors, String name, String title, String issue, String link, String type, List<String> labels) {
        Preconditions.checkState((!commits.isEmpty() ? 1 : 0) != 0, (Object)"commits");
        this.commits = commits;
        this.authors = (List)Preconditions.checkNotNull(authors, (Object)"authors");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.title = Strings.nullToEmpty((String)title);
        this.hasTitle = !Strings.isNullOrEmpty((String)title);
        this.issue = Strings.nullToEmpty((String)issue);
        this.hasIssue = !Strings.isNullOrEmpty((String)issue);
        this.link = Strings.nullToEmpty((String)link);
        this.hasLink = !Strings.isNullOrEmpty((String)link);
        this.hasType = !Strings.isNullOrEmpty((String)type);
        this.type = Strings.nullToEmpty((String)type);
        this.hasLabels = labels != null && !labels.isEmpty();
        this.labels = labels;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTitle() {
        return this.hasTitle;
    }

    public boolean hasIssue() {
        return this.hasIssue;
    }

    public boolean hasLabels() {
        return this.hasLabels;
    }

    public boolean hasType() {
        return this.hasType;
    }

    public boolean hasLink() {
        return this.hasLink;
    }

    public String getIssue() {
        return this.issue;
    }

    public String getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public List<Author> getAuthors() {
        return this.authors;
    }

    @Override
    public List<Commit> getCommits() {
        return this.commits;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public String toString() {
        return "Issue: " + this.issue + " Title: " + this.title;
    }
}

