/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.redmine;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.redmine.RedmineClient;
import se.bjurr.gitchangelog.internal.integrations.redmine.RedmineIssue;
import se.bjurr.gitchangelog.internal.integrations.rest.RestClient;

public class DefaultRedmineClient
extends RedmineClient {
    private RestClient client = new RestClient();

    public DefaultRedmineClient(String api) {
        super(api);
    }

    @Override
    public RedmineClient withBasicCredentials(String username, String password) {
        this.client = this.client.withBasicAuthCredentials(username, password);
        return this;
    }

    @Override
    public RedmineClient withTokenCredentials(String token) {
        String authToken;
        try {
            authToken = Base64.getEncoder().encodeToString((token + ":changelog").getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.client = this.client.withTokenAuthCredentials(authToken);
        return this;
    }

    @Override
    public RedmineClient withHeaders(Map<String, String> headers) {
        this.client = this.client.withHeaders(headers);
        return this;
    }

    @Override
    public Optional<RedmineIssue> getIssue(String issue) throws GitChangelogIntegrationException {
        String endpoint = this.getEndpoint(issue);
        Optional<String> json = this.client.get(endpoint);
        if (json.isPresent()) {
            String jsonString = json.get();
            try {
                RedmineIssue redmineIssue = this.toRedmineIssue(issue, jsonString);
                return Optional.of(redmineIssue);
            }
            catch (Exception e) {
                throw new GitChangelogIntegrationException("Unable to parse:\n" + jsonString, e);
            }
        }
        return Optional.empty();
    }
}

