/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;

public final class ResourceLoader {
    private ResourceLoader() {
    }

    public static String getResourceOrFile(String resourceName) {
        String templateString = null;
        try {
            Path templatePath = Paths.get(resourceName, new String[0]);
            if (templatePath.toFile().exists()) {
                templateString = new String(Files.readAllBytes(templatePath), StandardCharsets.UTF_8);
            } else {
                InputStream inputStream = ResourceLoader.getResourceFromClassLoader(resourceName, ResourceLoader.class.getClassLoader());
                if (inputStream == null) {
                    inputStream = ResourceLoader.getResourceFromClassLoader(resourceName, Thread.currentThread().getContextClassLoader());
                }
                if (inputStream == null) {
                    throw new FileNotFoundException("Was unable to find file, or resouce, \"" + resourceName + "\"");
                }
                templateString = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(resourceName, e);
        }
        return templateString;
    }

    private static InputStream getResourceFromClassLoader(String resourceName, ClassLoader classLoader) {
        InputStream inputStream = classLoader.getResourceAsStream(resourceName);
        if (inputStream == null) {
            inputStream = classLoader.getResourceAsStream("/" + resourceName);
        }
        return inputStream;
    }
}

