/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.settings;

import java.io.Serializable;
import java.util.Optional;
import se.bjurr.gitchangelog.internal.settings.SettingsIssueType;
import se.bjurr.gitchangelog.internal.util.Preconditions;

public class SettingsIssue
implements Serializable {
    private static final long serialVersionUID = -658106272421601880L;
    private final SettingsIssueType type;
    private final String name;
    private final String title;
    private final String pattern;
    private final String link;

    public SettingsIssue(String name, String pattern, String link, String title) {
        this.type = SettingsIssueType.CUSTOM;
        this.name = Preconditions.checkNotNull(name, "name");
        this.pattern = Preconditions.checkNotNull(pattern, "pattern");
        this.link = link;
        this.title = title;
    }

    public SettingsIssue(SettingsIssueType type, String name, String pattern, String link, String title) {
        this.type = Preconditions.checkNotNull(type, "type");
        this.name = Preconditions.checkNotNull(name, "name");
        this.pattern = Preconditions.checkNotNull(pattern, "pattern");
        this.link = link;
        this.title = title;
    }

    public SettingsIssueType getType() {
        return this.type;
    }

    public Optional<String> getLink() {
        return Optional.ofNullable(this.link);
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }
}

