/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.settings;

import com.google.gson.Gson;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import se.bjurr.gitchangelog.api.GitChangelogApiConstants;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;
import se.bjurr.gitchangelog.internal.util.Preconditions;

public class Settings
implements Serializable {
    private static final long serialVersionUID = 4565886594381385244L;
    private static Gson gson = new Gson();
    private String fromRepo;
    private String fromRef;
    private String toRef;
    private String fromCommit;
    private String toCommit;
    private String ignoreTagsIfNameMatches;
    private String ignoreCommitsIfMessageMatches;
    private Date ignoreCommitsIfOlderThan;
    private String untaggedName;
    private String templatePath;
    private String templateBaseDir;
    private String templateSuffix;
    private String readableTagName;
    private String dateFormat;
    private String noIssueName;
    private String timeZone;
    private boolean removeIssueFromMessage;
    private boolean jiraEnabled;
    private String jiraServer;
    private String jiraIssuePattern;
    private String jiraUsername;
    private String jiraPassword;
    private String jiraToken;
    private String jiraBearer;
    private boolean redmineEnabled;
    private String redmineServer;
    private String redmineIssuePattern;
    private String redmineUsername;
    private String redminePassword;
    private String redmineToken;
    private boolean gitHubEnabled;
    private String gitHubApi;
    private String gitHubToken;
    private String gitHubIssuePattern;
    private List<SettingsIssue> customIssues;
    private Map<String, Object> extendedVariables = new HashMap<String, Object>();
    private Map<String, String> extendedRestHeaders;
    private boolean ignoreCommitsWithoutIssue;
    private boolean gitLabEnabled;
    private String gitLabServer;
    private String gitLabToken;
    private String gitLabIssuePattern;
    private String gitLabProjectName;
    private String semanticMajorPattern = null;
    private String semanticMinorPattern = null;
    private String semanticPatchPattern;
    private String subDirFilter;

    public String getSubDirFilter() {
        return Optional.ofNullable(this.subDirFilter).orElse("");
    }

    public void setPathFilter(String subDirFilter) {
        this.subDirFilter = subDirFilter;
    }

    public void setCustomIssues(List<SettingsIssue> customIssues) {
        this.customIssues = customIssues;
    }

    public void setFromRef(String fromRef) {
        this.fromRef = fromRef == null || fromRef.trim().isEmpty() ? null : fromRef.trim();
    }

    public void setToRef(String toRef) {
        this.toRef = toRef == null || toRef.trim().isEmpty() ? null : toRef.trim();
    }

    public Optional<String> getFromRef() {
        return Optional.ofNullable(this.fromRef);
    }

    public Optional<String> getToRef() {
        return Optional.ofNullable(this.toRef);
    }

    public void setFromRepo(String fromRepo) {
        this.fromRepo = fromRepo;
    }

    public String getFromRepo() {
        return Optional.ofNullable(this.fromRepo).orElse(".");
    }

    public void setIgnoreCommitsIfMessageMatches(String ignoreCommitsIfMessageMatches) {
        this.ignoreCommitsIfMessageMatches = ignoreCommitsIfMessageMatches;
    }

    public void setIgnoreTagsIfNameMatches(String ignoreTagsIfNameMatches) {
        this.ignoreTagsIfNameMatches = ignoreTagsIfNameMatches;
    }

    public void setIgnoreCommitsIfOlderThan(Date ignoreCommitsIfOlderThan) {
        this.ignoreCommitsIfOlderThan = ignoreCommitsIfOlderThan != null ? new Date(ignoreCommitsIfOlderThan.getTime()) : null;
    }

    public void setJiraIssuePattern(String jiraIssuePattern) {
        this.jiraIssuePattern = jiraIssuePattern;
    }

    public void setJiraServer(String jiraServer) {
        this.jiraServer = jiraServer;
    }

    public void setRedmineIssuePattern(String redmineIssuePattern) {
        this.redmineIssuePattern = redmineIssuePattern;
    }

    public void setRedmineServer(String redmineServer) {
        this.redmineServer = redmineServer;
    }

    public void addCustomIssue(SettingsIssue customIssue) {
        if (this.customIssues == null) {
            this.customIssues = new ArrayList<SettingsIssue>();
        }
        this.customIssues.add(customIssue);
    }

    public List<SettingsIssue> getCustomIssues() {
        if (this.customIssues == null) {
            return new ArrayList<SettingsIssue>();
        }
        return this.customIssues;
    }

    public String getIgnoreCommitsIfMessageMatches() {
        return Optional.ofNullable(this.ignoreCommitsIfMessageMatches).orElse("");
    }

    public Optional<Date> getIgnoreCommitsIfOlderThan() {
        return Optional.ofNullable(this.ignoreCommitsIfOlderThan);
    }

    public String getJiraIssuePattern() {
        return Optional.ofNullable(this.jiraIssuePattern).orElse("\\b[a-zA-Z]([a-zA-Z]+)-([0-9]+)\\b");
    }

    public Optional<String> getJiraServer() {
        return Optional.ofNullable(this.jiraServer);
    }

    public String getRedmineIssuePattern() {
        return Optional.ofNullable(this.redmineIssuePattern).orElse("#([0-9]+)");
    }

    public Optional<String> getRedmineServer() {
        return Optional.ofNullable(this.redmineServer);
    }

    public static Settings fromFile(URL url) {
        try {
            return (Settings)gson.fromJson(new String(Files.readAllBytes(Paths.get(url.toURI())), StandardCharsets.UTF_8), Settings.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read " + url, e);
        }
    }

    public void setFromCommit(String fromCommit) {
        this.fromCommit = fromCommit;
    }

    public void setToCommit(String toCommit) {
        this.toCommit = toCommit;
    }

    public Optional<String> getFromCommit() {
        return Optional.ofNullable(Preconditions.emptyToNull(this.fromCommit));
    }

    public Optional<String> getToCommit() {
        return Optional.ofNullable(Preconditions.emptyToNull(this.toCommit));
    }

    public String getUntaggedName() {
        return Optional.ofNullable(this.untaggedName).orElse("Unreleased");
    }

    public Optional<String> getIgnoreTagsIfNameMatches() {
        return Optional.ofNullable(this.ignoreTagsIfNameMatches);
    }

    public void setUntaggedName(String untaggedName) {
        this.untaggedName = untaggedName;
    }

    public String getTemplatePath() {
        return Optional.ofNullable(this.templatePath).orElse("changelog.mustache");
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getTemplateBaseDir() {
        return this.templateBaseDir;
    }

    public void setTemplateBaseDir(String templateBaseDir) {
        this.templateBaseDir = templateBaseDir;
    }

    public String getTemplateSuffix() {
        return this.templateSuffix;
    }

    public void setTemplateSuffix(String templateSuffix) {
        this.templateSuffix = templateSuffix;
    }

    public String getReadableTagName() {
        return Optional.ofNullable(this.readableTagName).orElse("/([^/]+?)$");
    }

    public String getDateFormat() {
        return Optional.ofNullable(this.dateFormat).orElse("yyyy-MM-dd HH:mm:ss");
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setNoIssueName(String noIssueName) {
        this.noIssueName = noIssueName;
    }

    public void setReadableTagName(String readableTagName) {
        this.readableTagName = readableTagName;
    }

    public String getNoIssueName() {
        return Optional.ofNullable(this.noIssueName).orElse("No issue");
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeZone() {
        return Optional.ofNullable(this.timeZone).orElse("UTC");
    }

    public static Settings defaultSettings() {
        Settings s = new Settings();
        s.setFromRepo(".");
        s.setFromCommit("0000000000000000000000000000000000000000");
        s.setToRef("refs/heads/master");
        s.setIgnoreCommitsIfMessageMatches("^Merge.*");
        s.setTemplateSuffix(".hbs");
        s.setReadableTagName("/([^/]+?)$");
        s.setDateFormat("YYYY-MM-dd HH:mm:ss");
        s.setUntaggedName("No tag");
        s.setNoIssueName("No issue");
        s.setTimeZone("UTC");
        s.setRemoveIssueFromMessage(true);
        s.setJiraIssuePattern("\\\\b[a-zA-Z]([a-zA-Z]+)-([0-9]+)\\\\b");
        return s;
    }

    public void setRemoveIssueFromMessage(boolean removeIssueFromMessage) {
        this.removeIssueFromMessage = removeIssueFromMessage;
    }

    public Boolean removeIssueFromMessage() {
        return Optional.ofNullable(this.removeIssueFromMessage).orElse(true);
    }

    public Optional<String> getGitHubApi() {
        return Optional.ofNullable(this.gitHubApi);
    }

    public Optional<String> getGitHubToken() {
        return Optional.ofNullable(this.gitHubToken);
    }

    public void setGitHubApi(String gitHubApi) {
        this.gitHubApi = gitHubApi;
    }

    public void setGitHubToken(String gitHubToken) {
        this.gitHubToken = gitHubToken;
    }

    public void setGitHubIssuePattern(String gitHubIssuePattern) {
        this.gitHubIssuePattern = gitHubIssuePattern;
    }

    public String getGitHubIssuePattern() {
        return Optional.ofNullable(this.gitHubIssuePattern).orElse("#([0-9]+)");
    }

    public Optional<String> getJiraUsername() {
        return Optional.ofNullable(this.jiraUsername);
    }

    public void setJiraPassword(String jiraPassword) {
        this.jiraPassword = jiraPassword;
    }

    public void setJiraToken(String jiraToken) {
        this.jiraToken = jiraToken;
    }

    public void setJiraBearer(String jiraBearer) {
        this.jiraBearer = jiraBearer;
    }

    public void setJiraUsername(String jiraUsername) {
        this.jiraUsername = jiraUsername;
    }

    public Optional<String> getJiraPassword() {
        return Optional.ofNullable(this.jiraPassword);
    }

    public Optional<String> getJiraToken() {
        return Optional.ofNullable(this.jiraToken);
    }

    public Optional<String> getJiraBearer() {
        return Optional.ofNullable(this.jiraBearer);
    }

    public Optional<String> getRedmineUsername() {
        return Optional.ofNullable(this.redmineUsername);
    }

    public void setRedminePassword(String redminePassword) {
        this.redminePassword = redminePassword;
    }

    public void setRedmineToken(String redmineToken) {
        this.redmineToken = redmineToken;
    }

    public void setRedmineUsername(String redmineUsername) {
        this.redmineUsername = redmineUsername;
    }

    public Optional<String> getRedminePassword() {
        return Optional.ofNullable(this.redminePassword);
    }

    public Optional<String> getRedmineToken() {
        return Optional.ofNullable(this.redmineToken);
    }

    public void setExtendedVariables(Map<String, Object> extendedVariables) {
        this.extendedVariables = extendedVariables;
    }

    public Map<String, Object> getExtendedVariables() {
        return this.extendedVariables;
    }

    public Map<String, String> getExtendedRestHeaders() {
        return this.extendedRestHeaders;
    }

    public void setExtendedRestHeaders(Map<String, String> extendedRestHeaders) {
        this.extendedRestHeaders = extendedRestHeaders;
    }

    public void setIgnoreCommitsWithoutIssue(boolean ignoreCommitsWithoutIssue) {
        this.ignoreCommitsWithoutIssue = ignoreCommitsWithoutIssue;
    }

    public boolean ignoreCommitsWithoutIssue() {
        return this.ignoreCommitsWithoutIssue;
    }

    public void setGitLabIssuePattern(String gitLabIssuePattern) {
        this.gitLabIssuePattern = gitLabIssuePattern;
    }

    public void setGitLabProjectName(String gitLabProjectName) {
        this.gitLabProjectName = gitLabProjectName;
    }

    public void setGitLabServer(String gitLabServer) {
        this.gitLabServer = gitLabServer;
    }

    public void setGitLabToken(String gitLabToken) {
        this.gitLabToken = gitLabToken;
    }

    public Optional<String> getGitLabServer() {
        return Optional.ofNullable(this.gitLabServer);
    }

    public Optional<String> getGitLabToken() {
        return Optional.ofNullable(this.gitLabToken);
    }

    public String getGitLabIssuePattern() {
        return Optional.ofNullable(this.gitLabIssuePattern).orElse("#([0-9]+)");
    }

    public Optional<String> getGitLabProjectName() {
        return Optional.ofNullable(this.gitLabProjectName);
    }

    public Optional<String> getSemanticMajorPattern() {
        return Optional.ofNullable(this.semanticMajorPattern);
    }

    public void setSemanticMajorPattern(String semanticMajorPattern) {
        this.semanticMajorPattern = this.isRegexp(semanticMajorPattern, "semanticMajorPattern");
    }

    public String getSemanticMinorPattern() {
        return Optional.ofNullable(this.semanticMinorPattern).orElse("^[Ff]eat.*");
    }

    public void setSemanticMinorPattern(String semanticMinorPattern) {
        this.semanticMinorPattern = this.isRegexp(semanticMinorPattern, "semanticMinorPattern");
    }

    public String getSemanticPatchPattern() {
        return Optional.ofNullable(this.semanticPatchPattern).orElse(GitChangelogApiConstants.DEFAULT_PATCH_PATTERN);
    }

    public void setSemanticPatchPattern(String semanticPatchPattern) {
        this.semanticPatchPattern = this.isRegexp(semanticPatchPattern, "semanticPatchPattern");
    }

    private String isRegexp(String pattern, String string) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException(pattern + " in " + string + " is not valid regexp.");
        }
        return pattern;
    }

    public void setGitHubEnabled(boolean githubEnabled) {
        this.gitHubEnabled = githubEnabled;
    }

    public void setGitLabEnabled(boolean gitlabEnabled) {
        this.gitLabEnabled = gitlabEnabled;
    }

    public void setJiraEnabled(boolean jiraEnabled) {
        this.jiraEnabled = jiraEnabled;
    }

    public void setRedmineEnabled(boolean redmineEnabled) {
        this.redmineEnabled = redmineEnabled;
    }

    public boolean isGitHubEnabled() {
        return this.gitHubEnabled;
    }

    public boolean isGitLabEnabled() {
        return this.gitLabEnabled;
    }

    public boolean isJiraEnabled() {
        return this.jiraEnabled;
    }

    public boolean isRedmineEnabled() {
        return this.redmineEnabled;
    }
}

