/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.github;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import retrofit2.Call;
import retrofit2.Response;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubIssue;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubService;

public class GitHubHelper {
    private static Pattern PAGE_PATTERN = Pattern.compile("page=([0-9]+)>");
    private final GitHubService service;

    public GitHubHelper(GitHubService service) {
        this.service = service;
    }

    public Optional<GitHubIssue> getIssueFromAll(String issue) throws GitChangelogIntegrationException {
        if (issue.startsWith("#")) {
            issue = issue.substring(1);
        }
        int page = 1;
        while (page > 0) {
            Call<List<GitHubIssue>> call = this.service.issues(page);
            page = -1;
            try {
                Response response = call.execute();
                if (!response.isSuccessful()) {
                    throw new GitChangelogIntegrationException("Request:" + response.raw().request().toString() + "\nError:\n" + response.errorBody().string());
                }
                if (response.headers().get("Link") != null) {
                    String link = response.headers().get("Link");
                    String parsedPage = null;
                    block3: for (String part : Arrays.asList(link.split(","))) {
                        for (String piece : Arrays.asList(part.split(";"))) {
                            Matcher match;
                            if ("rel=\"next\"".equals(piece.trim()) && parsedPage != null) {
                                page = Integer.parseInt(parsedPage);
                                break block3;
                            }
                            if (!piece.contains("&page=") || !(match = PAGE_PATTERN.matcher(piece)).find()) continue;
                            parsedPage = match.group(1);
                        }
                    }
                }
                for (GitHubIssue gitHubIssue : (List)response.body()) {
                    if (!issue.equals(gitHubIssue.getNumber())) continue;
                    return Optional.of(gitHubIssue);
                }
            }
            catch (IOException e) {
                throw new GitChangelogIntegrationException(issue, e);
            }
        }
        return Optional.empty();
    }
}

