/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.helper.EachHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import se.bjurr.gitchangelog.internal.semantic.ConventionalCommitParser;

public class Helpers {
    public static final Map<String, Helper<?>> ALL = new TreeMap();

    private static Object each(Options options, List<?> elements) throws IOException {
        return new EachHelper().apply(elements, options);
    }

    private static Options.Buffer conditional(Options options, boolean condition) throws IOException {
        Options.Buffer buffer = options.buffer();
        if (condition) {
            buffer.append(options.fn());
        } else {
            buffer.append(options.inverse());
        }
        return buffer;
    }

    static {
        ALL.put("ifEquals", (a, options) -> {
            Object b = options.params[0];
            boolean equality = a.equals(b);
            return Helpers.conditional(options, equality);
        });
        ALL.put("ifMatches", (a, options) -> {
            String regexp = (String)options.params[0];
            boolean equality = a.toString().matches(regexp);
            return Helpers.conditional(options, equality);
        });
        ALL.put("subString", (a, options) -> {
            Integer from = (Integer)options.params[0];
            if (options.params.length == 1) {
                return a.toString().substring(from);
            }
            Integer to = (Integer)options.params[1];
            return a.toString().substring(from, to);
        });
        ALL.put("ifReleaseTag", (tag, options) -> Helpers.conditional(options, ConventionalCommitParser.isReleaseTag(tag)));
        ALL.put("tagDate", (tag, options) -> ConventionalCommitParser.getDate(tag.getTagTime()));
        ALL.put("commitDate", (commit, options) -> ConventionalCommitParser.getDate(commit.getCommitTime()));
        ALL.put("ifContainsType", (commits, options) -> Helpers.conditional(options, ConventionalCommitParser.containsType(commits, options)));
        ALL.put("ifContainsTypeOtherThan", (commits, options) -> Helpers.conditional(options, ConventionalCommitParser.containsTypeOtherThan(commits, options)));
        ALL.put("ifContainsBreaking", (commits, options) -> Helpers.conditional(options, ConventionalCommitParser.containsBreaking(commits, options)));
        ALL.put("ifCommitType", (commit, options) -> Helpers.conditional(options, ConventionalCommitParser.commitType(commit.getMessage(), options)));
        ALL.put("ifCommitTypeOtherThan", (commit, options) -> Helpers.conditional(options, !ConventionalCommitParser.commitType(commit.getMessage(), options)));
        ALL.put("ifCommitBreaking", (commit, options) -> Helpers.conditional(options, ConventionalCommitParser.commitBreaking(commit.getMessage())));
        ALL.put("ifCommitScope", (commit, options) -> Helpers.conditional(options, ConventionalCommitParser.commitScope(commit, options)));
        ALL.put("ifCommitHasFooters", (commit, options) -> Helpers.conditional(options, ConventionalCommitParser.getMessageParts((String)commit.getMessage()).footers.size() > 0));
        ALL.put("ifCommitHasParagraphs", (commit, options) -> Helpers.conditional(options, ConventionalCommitParser.getMessageParts((String)commit.getMessage()).paragraphs.size() > 0));
        ALL.put("eachCommitScope", (commit, options) -> Helpers.each(options, ConventionalCommitParser.commitScopes(commit.getMessage())));
        ALL.put("commitDescription", (commit, options) -> ConventionalCommitParser.commitDescription(commit.getMessage()));
        ALL.put("eachCommitRefs", (commit, options) -> Helpers.each(options, ConventionalCommitParser.commitRefs(commit.getMessage())));
        ALL.put("eachCommitFixes", (commit, options) -> Helpers.each(options, ConventionalCommitParser.commitFixes(commit.getMessage())));
        ALL.put("revertedCommit", (commit, options) -> ConventionalCommitParser.revertedCommit(commit.getMessage()));
        ALL.put("eachCommitParagraph", (commit, options) -> Helpers.each(options, ConventionalCommitParser.getMessageParts((String)commit.getMessage()).paragraphs));
        ALL.put("eachCommitFooter", (commit, options) -> Helpers.each(options, ConventionalCommitParser.getMessageParts((String)commit.getMessage()).footers));
        ALL.put("ifFooterHasValue", (footer, options) -> Helpers.conditional(options, !footer.value.trim().isEmpty()));
    }
}

