/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.plugin.gradle;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import se.bjurr.gitchangelog.plugin.gradle.GitChangelogPluginExtension;
import se.bjurr.gitchangelog.plugin.gradle.GitChangelogSemanticVersionTask;
import se.bjurr.gitchangelog.plugin.gradle.GitChangelogTask;
import se.bjurr.gitchangelog.plugin.gradle.SetSemanticVersion;
import se.bjurr.gitchangelog.plugin.gradle.SetSemanticVersionParameters;

public class GitChangelogGradlePlugin
implements Plugin<Project> {
    public void apply(Project target) {
        String setVersionConventional = this.getOrElse(target, "setVersionConventional", "false");
        if (setVersionConventional != null && setVersionConventional.equals("true")) {
            SetSemanticVersion.setVersion(this.getSemanticVersionParamsFromProperties(target.getProject()));
        }
        target.getExtensions().create("gitChangelogPlugin", GitChangelogPluginExtension.class, new Object[0]);
        target.getTasks().register("gitChangelogSemanticVersion", GitChangelogSemanticVersionTask.class, task -> {
            task.setDescription("Set version in gradle.properties from conventional commits.");
            task.setGroup("Git Changelog");
        });
        target.getTasks().register("gitChangelog", GitChangelogTask.class, task -> {
            task.setDescription("Update CHANGELOG.md using conventional commits.");
            task.setGroup("Git Changelog");
            task.ignoreCommitsIfMessageMatches = "^\\[maven-release-plugin\\].*|^\\[Gradle Release Plugin\\].*|^Merge.*|.*\\[GRADLE SCRIPT\\].*";
        });
    }

    private SetSemanticVersionParameters getSemanticVersionParamsFromProperties(Project project) {
        SetSemanticVersionParameters params = new SetSemanticVersionParameters();
        params.suffixSnapshot = this.getOrElse(project, "suffixSnapshot", false);
        params.suffixSnapshotIfNotTagged = this.getOrElse(project, "suffixSnapshotIfNotTagged", true);
        params.majorVersionPattern = this.getOrElse(project, "majorVersionPattern", null);
        params.minorVersionPattern = this.getOrElse(project, "minorVersionPattern", null);
        params.patchVersionPattern = this.getOrElse(project, "patchVersionPattern", null);
        params.ignoreTagsIfNameMatches = this.getOrElse(project, "ignoreTagsIfNameMatches", null);
        params.project = project;
        return params;
    }

    private String getOrElse(Project project, String key, String defaul) {
        Gradle gradle = project.getRootProject().getGradle();
        Object valueOpt = gradle.getExtensions().getExtraProperties().getProperties().get(key);
        project.getLogger().info("Got '" + valueOpt + "' from extraProperties key '" + key + "'");
        if (valueOpt == null) {
            valueOpt = project.getProperties().get(key);
            project.getLogger().info("Got '" + valueOpt + "' from properties key '" + key + "'");
        }
        if (valueOpt == null) {
            project.getLogger().info("Using default '" + defaul + "' for key '" + key + "'");
            return defaul;
        }
        project.getLogger().info("Using '" + valueOpt + "' for key '" + key + "'");
        return valueOpt.toString();
    }

    private Boolean getOrElse(Project project, String key, boolean defaul) {
        String value = this.getOrElse(project, key, Boolean.toString(defaul));
        return Boolean.valueOf(value);
    }
}

