/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.plugin.gradle;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.GitChangelogApi;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersion;
import se.bjurr.gitchangelog.plugin.gradle.SortedProperties;

public class GitChangelogSemanticVersionTask
extends DefaultTask {
    private static final Logger log = LoggerFactory.getLogger((String)GitChangelogSemanticVersionTask.class.getName());
    public Boolean suffixSnapshot = false;
    public Boolean suffixSnapshotIfNotTagged = true;
    public String majorVersionPattern;
    public String minorVersionPattern;
    public String patchVersionPattern;
    public String ignoreTagsIfNameMatches;

    @TaskAction
    public void gitChangelogPluginTasks() {
        block20: {
            try {
                GitChangelogApi gitChangelogApiBuilder = GitChangelogApi.gitChangelogApiBuilder();
                gitChangelogApiBuilder.withFromRepo(this.getProject().getRootDir());
                if (this.isSupplied(this.majorVersionPattern)) {
                    gitChangelogApiBuilder.withSemanticMajorVersionPattern(this.majorVersionPattern);
                }
                if (this.isSupplied(this.minorVersionPattern)) {
                    gitChangelogApiBuilder.withSemanticMinorVersionPattern(this.minorVersionPattern);
                }
                if (this.isSupplied(this.patchVersionPattern)) {
                    gitChangelogApiBuilder.withSemanticPatchVersionPattern(this.patchVersionPattern);
                }
                if (this.isSupplied(this.ignoreTagsIfNameMatches)) {
                    gitChangelogApiBuilder.withIgnoreTagsIfNameMatches(this.ignoreTagsIfNameMatches);
                }
                SemanticVersion nextSemanticVersion = gitChangelogApiBuilder.getCurrentSemanticVersion();
                boolean notTagged = nextSemanticVersion.findTag().isEmpty();
                boolean suffixWithSnapshot = this.isSuppliedAndTrue(this.suffixSnapshot) || this.isSuppliedAndTrue(this.suffixSnapshotIfNotTagged) && notTagged;
                Object nextVersion = suffixWithSnapshot ? nextSemanticVersion.getVersion() + "-SNAPSHOT" : nextSemanticVersion.getVersion();
                File propertyFile = this.getProject().getRootProject().file((Object)"gradle.properties");
                SortedProperties gradleProps = new SortedProperties();
                try (InputStream is = Files.newInputStream(propertyFile.toPath(), new OpenOption[0]);){
                    gradleProps.load(is);
                }
                String currentVersion = gradleProps.getProperty("version");
                if (((String)nextVersion).equals(currentVersion)) {
                    this.getProject().getLogger().info("Leaving semantic version " + currentVersion + " unchanged.");
                    break block20;
                }
                this.getProject().getLogger().lifecycle("Setting semantic version to " + (String)nextVersion + " (was " + currentVersion + "). Storing in " + propertyFile);
                gradleProps.setProperty("version", (String)nextVersion);
                try (OutputStream os = Files.newOutputStream(propertyFile.toPath(), new OpenOption[0]);){
                    gradleProps.store(os, "");
                }
                this.getProject().setVersion(nextVersion);
            }
            catch (Exception e) {
                log.error("GitChangelogVersion", (Throwable)e);
            }
        }
    }

    private boolean isSuppliedAndTrue(Boolean param) {
        return param != null && param != false;
    }

    private boolean isSupplied(String param) {
        return param != null && !param.isEmpty();
    }
}

