/*
 * Decompiled with CFR 0.152.
 */
package se.aaro.gustav.passwordstrengthmeter;

import android.animation.ArgbEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import se.aaro.gustav.passwordstrengthmeter.PasswordStrengthLevel;

class StrengthIndicatorView
extends View {
    private int height;
    private int currentLineWidth;
    private int correctLineWidth;
    private int currentColor;
    private int correctColor;
    private Paint linePaint = new Paint();
    private Paint backgroundPaint = new Paint();
    private int securityLevel = 0;
    private static String TAG = "StrengthIndicatorView";
    private boolean animate;
    private int animDuration;
    private PasswordStrengthLevel[] levels;

    public StrengthIndicatorView(Context context) {
        super(context);
    }

    public void setPasswordStrengthLevels(PasswordStrengthLevel[] levels) {
        this.backgroundPaint.setColor(this.getResources().getColor(levels[0].getIndicatorColor()));
        this.currentColor = this.getResources().getColor(levels[0].getIndicatorColor());
        this.levels = levels;
        this.invalidate();
        this.refresh();
    }

    public StrengthIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setAnimDuration(int animDuration) {
        this.animDuration = animDuration;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void refresh() {
        int duration = this.animate ? this.animDuration : 0;
        PropertyValuesHolder colorProp = PropertyValuesHolder.ofInt((String)"color", (int[])new int[]{this.currentColor, this.correctColor});
        PropertyValuesHolder widthProperty = PropertyValuesHolder.ofInt((String)"width", (int[])new int[]{this.currentLineWidth, this.correctLineWidth});
        ValueAnimator colorAnim = new ValueAnimator();
        colorAnim.setDuration((long)duration);
        colorAnim.setValues(new PropertyValuesHolder[]{colorProp, widthProperty});
        colorAnim.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        colorAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        colorAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                StrengthIndicatorView.this.currentColor = (Integer)animation.getAnimatedValue("color");
                StrengthIndicatorView.this.currentLineWidth = (Integer)animation.getAnimatedValue("width");
                StrengthIndicatorView.this.invalidate();
            }
        });
        colorAnim.start();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(widthMeasureSpec, this.height);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.setSecurityLevel(this.securityLevel, true);
        }
    }

    public void setSecurityLevel(int level, boolean force) {
        if (force || this.securityLevel != level) {
            this.securityLevel = level;
            this.correctLineWidth = level + 1 == this.levels.length ? this.getWidth() : this.getMeasuredWidth() / (this.levels.length - 1) * level;
            this.correctColor = this.getResources().getColor(this.levels[level].getIndicatorColor());
            this.refresh();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.linePaint.setStrokeWidth((float)this.height);
        this.linePaint.setColor(this.currentColor);
        this.backgroundPaint.setStrokeWidth((float)this.height);
        canvas.drawLine(0.0f, (float)(this.height / 2), (float)this.getWidth(), (float)(this.height / 2), this.backgroundPaint);
        canvas.drawLine(0.0f, (float)(this.height / 2), (float)this.currentLineWidth, (float)(this.height / 2), this.linePaint);
    }
}

