/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.security.nacos.roles;

import com.alibaba.nacos.config.server.auth.PermissionInfo;
import com.alibaba.nacos.config.server.auth.PermissionPersistService;
import com.alibaba.nacos.config.server.auth.RoleInfo;
import com.alibaba.nacos.config.server.auth.RolePersistService;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.console.security.nacos.users.NacosUserDetailsServiceImpl;
import com.alibaba.nacos.core.auth.AuthConfigs;
import com.alibaba.nacos.core.auth.Permission;
import com.alibaba.nacos.core.utils.Loggers;
import io.jsonwebtoken.lang.Collections;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.mina.util.ConcurrentHashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class NacosRoleServiceImpl {
    public static final String GLOBAL_ADMIN_ROLE = "ROLE_ADMIN";
    @Autowired
    private AuthConfigs authConfigs;
    @Autowired
    private RolePersistService rolePersistService;
    @Autowired
    private NacosUserDetailsServiceImpl userDetailsService;
    @Autowired
    private PermissionPersistService permissionPersistService;
    private Set<String> roleSet = new ConcurrentHashSet();
    private Map<String, List<RoleInfo>> roleInfoMap = new ConcurrentHashMap<String, List<RoleInfo>>();
    private Map<String, List<PermissionInfo>> permissionInfoMap = new ConcurrentHashMap<String, List<PermissionInfo>>();

    @Scheduled(initialDelay=5000L, fixedDelay=15000L)
    private void reload() {
        try {
            Page roleInfoPage = this.rolePersistService.getRolesByUserName("", 1, Integer.MAX_VALUE);
            if (roleInfoPage == null) {
                return;
            }
            HashSet<String> tmpRoleSet = new HashSet<String>(16);
            ConcurrentHashMap<String, List<RoleInfo>> tmpRoleInfoMap = new ConcurrentHashMap<String, List<RoleInfo>>(16);
            for (RoleInfo roleInfo : roleInfoPage.getPageItems()) {
                if (!tmpRoleInfoMap.containsKey(roleInfo.getUsername())) {
                    tmpRoleInfoMap.put(roleInfo.getUsername(), new ArrayList());
                }
                ((List)tmpRoleInfoMap.get(roleInfo.getUsername())).add(roleInfo);
                tmpRoleSet.add(roleInfo.getRole());
            }
            ConcurrentHashMap<String, List<PermissionInfo>> tmpPermissionInfoMap = new ConcurrentHashMap<String, List<PermissionInfo>>(16);
            for (String role : tmpRoleSet) {
                Page permissionInfoPage = this.permissionPersistService.getPermissions(role, 1, Integer.MAX_VALUE);
                tmpPermissionInfoMap.put(role, permissionInfoPage.getPageItems());
            }
            this.roleSet = tmpRoleSet;
            this.roleInfoMap = tmpRoleInfoMap;
            this.permissionInfoMap = tmpPermissionInfoMap;
        }
        catch (Exception e) {
            Loggers.AUTH.warn("[LOAD-ROLES] load failed", (Throwable)e);
        }
    }

    public boolean hasPermission(String username, Permission permission) {
        List<RoleInfo> roleInfoList = this.getRoles(username);
        if (Collections.isEmpty(roleInfoList)) {
            return false;
        }
        for (RoleInfo roleInfo : roleInfoList) {
            if (!GLOBAL_ADMIN_ROLE.equals(roleInfo.getRole())) continue;
            return true;
        }
        if (permission.getResource().startsWith("console/")) {
            return false;
        }
        for (RoleInfo roleInfo : roleInfoList) {
            List<PermissionInfo> permissionInfoList = this.getPermissions(roleInfo.getRole());
            if (Collections.isEmpty(permissionInfoList)) continue;
            for (PermissionInfo permissionInfo : permissionInfoList) {
                String permissionResource = permissionInfo.getResource().replaceAll("\\*", ".*");
                String permissionAction = permissionInfo.getAction();
                if (!permissionAction.contains(permission.getAction()) || !Pattern.matches(permissionResource, permission.getResource())) continue;
                return true;
            }
        }
        return false;
    }

    public List<RoleInfo> getRoles(String username) {
        Page<RoleInfo> roleInfoPage;
        List roleInfoList = this.roleInfoMap.get(username);
        if (!this.authConfigs.isCachingEnabled() && (roleInfoPage = this.getRolesFromDatabase(username, 1, Integer.MAX_VALUE)) != null) {
            roleInfoList = roleInfoPage.getPageItems();
        }
        return roleInfoList;
    }

    public Page<RoleInfo> getRolesFromDatabase(String userName, int pageNo, int pageSize) {
        Page roles = this.rolePersistService.getRolesByUserName(userName, pageNo, pageSize);
        if (roles == null) {
            return new Page();
        }
        return roles;
    }

    public List<PermissionInfo> getPermissions(String role) {
        Page<PermissionInfo> permissionInfoPage;
        List permissionInfoList = this.permissionInfoMap.get(role);
        if (!this.authConfigs.isCachingEnabled() && (permissionInfoPage = this.getPermissionsFromDatabase(role, 1, Integer.MAX_VALUE)) != null) {
            permissionInfoList = permissionInfoPage.getPageItems();
        }
        return permissionInfoList;
    }

    public Page<PermissionInfo> getPermissionsByRoleFromDatabase(String role, int pageNo, int pageSize) {
        return this.permissionPersistService.getPermissions(role, pageNo, pageSize);
    }

    public void addRole(String role, String username) {
        if (this.userDetailsService.getUser(username) == null) {
            throw new IllegalArgumentException("user '" + username + "' not found!");
        }
        if (GLOBAL_ADMIN_ROLE.equals(role)) {
            throw new IllegalArgumentException("role 'ROLE_ADMIN' is not permitted to create!");
        }
        this.rolePersistService.addRole(role, username);
        this.roleSet.add(role);
    }

    public void deleteRole(String role, String userName) {
        this.rolePersistService.deleteRole(role, userName);
    }

    public void deleteRole(String role) {
        this.rolePersistService.deleteRole(role);
        this.roleSet.remove(role);
    }

    public Page<PermissionInfo> getPermissionsFromDatabase(String role, int pageNo, int pageSize) {
        Page pageInfo = this.permissionPersistService.getPermissions(role, pageNo, pageSize);
        if (pageInfo == null) {
            return new Page();
        }
        return pageInfo;
    }

    public void addPermission(String role, String resource, String action) {
        if (!this.roleSet.contains(role)) {
            throw new IllegalArgumentException("role " + role + " not found!");
        }
        this.permissionPersistService.addPermission(role, resource, action);
    }

    public void deletePermission(String role, String resource, String action) {
        this.permissionPersistService.deletePermission(role, resource, action);
    }
}

