/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.security.nacos;

import com.alibaba.nacos.console.filter.JwtAuthenticationTokenFilter;
import com.alibaba.nacos.console.security.nacos.JwtAuthenticationEntryPoint;
import com.alibaba.nacos.console.security.nacos.JwtTokenManager;
import com.alibaba.nacos.console.security.nacos.users.NacosUserDetailsServiceImpl;
import com.alibaba.nacos.core.auth.AuthConfigs;
import com.alibaba.nacos.core.auth.AuthSystemTypes;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsUtils;

@Configuration
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class NacosAuthConfig
extends WebSecurityConfigurerAdapter {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String SECURITY_IGNORE_URLS_SPILT_CHAR = ",";
    public static final String LOGIN_ENTRY_POINT = "/v1/auth/login";
    public static final String TOKEN_BASED_AUTH_ENTRY_POINT = "/v1/auth/**";
    public static final String TOKEN_PREFIX = "Bearer ";
    public static final String CONSOLE_RESOURCE_NAME_PREFIX = "console/";
    @Autowired
    private Environment env;
    @Autowired
    private JwtTokenManager tokenProvider;
    @Autowired
    private AuthConfigs authConfigs;
    @Autowired
    private NacosUserDetailsServiceImpl userDetailsService;

    @Bean(name={"org.springframework.security.authenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    public void configure(WebSecurity web) {
        String ignoreURLs = null;
        if (AuthSystemTypes.NACOS.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            ignoreURLs = "/**";
        }
        if (StringUtils.isBlank((CharSequence)this.authConfigs.getNacosAuthSystemType())) {
            ignoreURLs = this.env.getProperty("nacos.security.ignore.urls", "/**");
        }
        if (StringUtils.isNotBlank((CharSequence)ignoreURLs)) {
            for (String ignoreURL : ignoreURLs.trim().split(SECURITY_IGNORE_URLS_SPILT_CHAR)) {
                web.ignoring().antMatchers(new String[]{ignoreURL.trim()});
            }
        }
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService((UserDetailsService)this.userDetailsService).passwordEncoder(this.passwordEncoder());
    }

    protected void configure(HttpSecurity http) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.authConfigs.getNacosAuthSystemType())) {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).cors().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll().antMatchers(new String[]{LOGIN_ENTRY_POINT})).permitAll().and()).authorizeRequests().antMatchers(new String[]{TOKEN_BASED_AUTH_ENTRY_POINT})).authenticated().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new JwtAuthenticationEntryPoint());
            http.headers().cacheControl();
            http.addFilterBefore((Filter)new JwtAuthenticationTokenFilter(this.tokenProvider), UsernamePasswordAuthenticationFilter.class);
        }
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }
}

