/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.config.server.auth.RoleInfo;
import com.alibaba.nacos.config.server.model.RestResult;
import com.alibaba.nacos.config.server.model.User;
import com.alibaba.nacos.console.security.nacos.NacosAuthManager;
import com.alibaba.nacos.console.security.nacos.roles.NacosRoleServiceImpl;
import com.alibaba.nacos.console.security.nacos.users.NacosUser;
import com.alibaba.nacos.console.security.nacos.users.NacosUserDetailsServiceImpl;
import com.alibaba.nacos.console.utils.JwtTokenUtils;
import com.alibaba.nacos.console.utils.PasswordEncoderUtil;
import com.alibaba.nacos.core.auth.AccessException;
import com.alibaba.nacos.core.auth.ActionTypes;
import com.alibaba.nacos.core.auth.AuthConfigs;
import com.alibaba.nacos.core.auth.AuthSystemTypes;
import com.alibaba.nacos.core.auth.Secured;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="user")
@RequestMapping(value={"/v1/auth", "/v1/auth/users"})
public class UserController {
    @Autowired
    private JwtTokenUtils jwtTokenUtils;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private NacosUserDetailsServiceImpl userDetailsService;
    @Autowired
    private NacosRoleServiceImpl roleService;
    @Autowired
    private AuthConfigs authConfigs;
    @Autowired
    private NacosAuthManager authManager;

    @Secured(resource="console/users", action=ActionTypes.WRITE)
    @PostMapping
    public Object createUser(@RequestParam String username, @RequestParam String password) {
        User user = this.userDetailsService.getUserFromDatabase(username);
        if (user != null) {
            throw new IllegalArgumentException("user '" + username + "' already exist!");
        }
        this.userDetailsService.createUser(username, PasswordEncoderUtil.encode(password));
        return new RestResult(200, "create user ok!");
    }

    @DeleteMapping
    @Secured(resource="console/users", action=ActionTypes.WRITE)
    public Object deleteUser(@RequestParam String username) {
        List<RoleInfo> roleInfoList = this.roleService.getRoles(username);
        if (roleInfoList != null) {
            for (RoleInfo roleInfo : roleInfoList) {
                if (!roleInfo.getRole().equals("ROLE_ADMIN")) continue;
                throw new IllegalArgumentException("cannot delete admin: " + username);
            }
        }
        this.userDetailsService.deleteUser(username);
        return new RestResult(200, "delete user ok!");
    }

    @PutMapping
    @Secured(resource="console/users", action=ActionTypes.WRITE)
    public Object updateUser(@RequestParam String username, @RequestParam String newPassword) {
        User user = this.userDetailsService.getUserFromDatabase(username);
        if (user == null) {
            throw new IllegalArgumentException("user " + username + " not exist!");
        }
        this.userDetailsService.updateUserPassword(username, PasswordEncoderUtil.encode(newPassword));
        return new RestResult(200, "update user ok!");
    }

    @GetMapping
    @Secured(resource="console/users", action=ActionTypes.READ)
    public Object getUsers(@RequestParam int pageNo, @RequestParam int pageSize) {
        return this.userDetailsService.getUsersFromDatabase(pageNo, pageSize);
    }

    @PostMapping(value={"/login"})
    public Object login(@RequestParam String username, @RequestParam String password, HttpServletResponse response, HttpServletRequest request) throws AccessException {
        if (AuthSystemTypes.NACOS.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            NacosUser user = (NacosUser)this.authManager.login(request);
            response.addHeader("Authorization", "Bearer " + user.getToken());
            JSONObject result = new JSONObject();
            result.put("accessToken", (Object)user.getToken());
            result.put("tokenTtl", (Object)this.authConfigs.getTokenValidityInSeconds());
            result.put("globalAdmin", (Object)user.isGlobalAdmin());
            return result;
        }
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        RestResult rr = new RestResult();
        try {
            Authentication authentication = this.authenticationManager.authenticate((Authentication)authenticationToken);
            SecurityContextHolder.getContext().setAuthentication(authentication);
            String token = this.jwtTokenUtils.createToken(authentication);
            response.addHeader("Authorization", "Bearer " + token);
            rr.setCode(200);
            rr.setData((Object)("Bearer " + token));
            return rr;
        }
        catch (BadCredentialsException authentication) {
            rr.setCode(401);
            rr.setMessage("Login failed");
            return rr;
        }
    }

    @PutMapping(value={"/password"})
    @Deprecated
    public RestResult<String> updatePassword(@RequestParam(value="oldPassword") String oldPassword, @RequestParam(value="newPassword") String newPassword) {
        RestResult rr = new RestResult();
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String username = ((UserDetails)principal).getUsername();
        User user = this.userDetailsService.getUserFromDatabase(username);
        String password = user.getPassword();
        try {
            if (PasswordEncoderUtil.matches(oldPassword, password).booleanValue()) {
                this.userDetailsService.updateUserPassword(username, PasswordEncoderUtil.encode(newPassword));
                rr.setCode(200);
                rr.setMessage("Update password success");
            } else {
                rr.setCode(401);
                rr.setMessage("Old password is invalid");
            }
        }
        catch (Exception e) {
            rr.setCode(500);
            rr.setMessage("Update userpassword failed");
        }
        return rr;
    }
}

