/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.CommonsArchiveEntryAdapter;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.IArchiveEntry;
import de.flapdoodle.embed.process.extract.IExtractionMatch;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresFilesToExtract
extends FilesToExtract {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresFilesToExtract.class);
    private static final String SKIP_PATTERN = "pgsql/(doc|include|symbols|pgAdmin[^/]*)/.+";
    private static final String EXECUTABLE_PATTERN = "pgsql/bin/.+";
    private final FileSet fileSet;
    private final String extractBasePath;

    public PostgresFilesToExtract(IDirectory dirFactory, ITempNaming executableNaming, FileSet fileSet, Distribution distribution) {
        super(dirFactory, executableNaming, fileSet);
        this.fileSet = fileSet;
        if (dirFactory.asFile() != null) {
            File file = new File(dirFactory.asFile(), "pgsql-" + distribution.getVersion().asInDownloadPath());
            if (!file.exists()) {
                file.mkdir();
            }
            this.extractBasePath = file.getPath();
        } else {
            this.extractBasePath = null;
        }
    }

    public IExtractionMatch find(final IArchiveEntry entry) {
        if (this.extractBasePath == null) {
            return null;
        }
        if (entry.getName().matches(SKIP_PATTERN)) {
            return null;
        }
        final Path path = Paths.get(this.extractBasePath, entry.getName());
        return new IExtractionMatch(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public File write(InputStream source, long size) throws IOException {
                boolean isSymLink = false;
                String linkName = "";
                if (entry instanceof CommonsArchiveEntryAdapter) {
                    try {
                        Field archiveEntryField = CommonsArchiveEntryAdapter.class.getDeclaredField("_entry");
                        archiveEntryField.setAccessible(true);
                        ArchiveEntry archiveEntry = (ArchiveEntry)archiveEntryField.get(entry);
                        if (archiveEntry instanceof TarArchiveEntry && (isSymLink = ((TarArchiveEntry)archiveEntry).isSymbolicLink())) {
                            linkName = ((TarArchiveEntry)archiveEntry).getLinkName();
                        }
                        archiveEntry.getSize();
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException("Check the version of de.flapdoodle.embed.process API. Has it changed?", e);
                    }
                }
                Class<PostgresFilesToExtract> clazz = PostgresFilesToExtract.class;
                synchronized (PostgresFilesToExtract.class) {
                    File outputFile = path.toFile();
                    if (entry.isDirectory()) {
                        if (!outputFile.exists()) {
                            de.flapdoodle.embed.process.io.file.Files.createDir((File)outputFile);
                        }
                    } else {
                        if (!outputFile.exists()) {
                            if (isSymLink) {
                                try {
                                    Path target = path.getParent().resolve(Paths.get(linkName, new String[0]));
                                    Files.createSymbolicLink(outputFile.toPath(), target, new FileAttribute[0]);
                                }
                                catch (Exception e) {
                                    LOGGER.trace("Failed to extract symlink", (Throwable)e);
                                }
                            } else {
                                de.flapdoodle.embed.process.io.file.Files.write((InputStream)source, (File)outputFile);
                            }
                        }
                        if (entry.getName().matches(PostgresFilesToExtract.EXECUTABLE_PATTERN)) {
                            outputFile.setExecutable(true);
                        }
                    }
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return outputFile;
                }
            }

            public FileType type() {
                for (FileSet.Entry matchingEntry : PostgresFilesToExtract.this.fileSet.entries()) {
                    if (!matchingEntry.matchingPattern().matcher(path.toString()).matches()) continue;
                    return matchingEntry.type();
                }
                return FileType.Library;
            }
        };
    }
}

