/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.camelot.plugin;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.closure.Closure;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.yandex.qatools.camelot.api.AggregatorRepository;
import ru.yandex.qatools.camelot.api.PluginsInterop;

public class PluginRepoUtils {
    private final PluginsInterop plugins;

    public PluginRepoUtils(PluginsInterop plugins) {
        this.plugins = plugins;
    }

    public Map<String, Object> getPluginStatesMap(Class pluginClass, boolean localKeysOnly) {
        return PluginRepoUtils.getPluginStatesMap(this.plugins.repo(pluginClass), localKeysOnly);
    }

    public Map<String, Object> getPluginStatesMap(String pluginId, boolean localKeysOnly) {
        return PluginRepoUtils.getPluginStatesMap(this.plugins.repo(pluginId), localKeysOnly);
    }

    public static <T> Map<String, T> getPluginStatesMap(AggregatorRepository<T> repo, boolean localKeysOnly) {
        Set keys = localKeysOnly ? repo.localKeys() : repo.keys();
        HashMap<String, Object> result = new HashMap<String, Object>(keys.size());
        for (String key : keys) {
            result.put(key, repo.get(key));
        }
        return result;
    }

    public Object getPluginState(Class pluginClass, String correlationKey) {
        return this.plugins.repo(pluginClass).get(correlationKey);
    }

    public Object getPluginState(String pluginId, String correlationKey) {
        return this.plugins.repo(pluginId).get(correlationKey);
    }

    public <T> List<T> getPluginStatesList(Class pluginClass, boolean localKeysOnly) {
        return PluginRepoUtils.getPluginStatesList(this.plugins.repo(pluginClass), localKeysOnly);
    }

    public <T> List<T> getPluginStatesList(String pluginId, boolean localKeysOnly) {
        return PluginRepoUtils.getPluginStatesList(this.plugins.repo(pluginId), localKeysOnly);
    }

    public static <T> List<T> getPluginStatesList(AggregatorRepository<T> repo, boolean localKeysOnly) {
        Closure closure = Lambda.closure();
        ((AggregatorRepository)Lambda.of(repo)).get((String)Lambda.var(String.class));
        return closure.each(new Iterable[]{localKeysOnly ? repo.localKeys() : repo.keys()});
    }
}

